<?php
require __DIR__ . '/../includes/koneksi.php';

$username = $_GET['username'] ?? null;
if (!$username) {
    echo json_encode(['error' => 'username required']);
    exit();
}

$stmt = $conn->prepare("SELECT id, username, tipe, nama, access_modul FROM users WHERE username = ? LIMIT 1");
$stmt->bind_param('s', $username);
$stmt->execute();
$res = $stmt->get_result();
$user = $res->fetch_assoc();
$stmt->close();

if (!$user) {
    echo json_encode(['error' => 'user not found']);
    exit();
}

$userId = (int)$user['id'];
$stmt = $conn->prepare("SELECT COUNT(*) AS c FROM approval_chain WHERE approver_id = ?");
$stmt->bind_param('i', $userId);
$stmt->execute();
$res = $stmt->get_result();
$count = $res->fetch_assoc()['c'] ?? 0;
$stmt->close();

// compute subordinated users via letter_order mapping
require_once __DIR__ . '/../includes/functions.php';
$subs = getSubordinatesForUser($conn, $userId);

echo json_encode([
    'user' => $user,
    'is_approver_count' => (int)$count,
    'subordinate_ids' => $subs
]);
