<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

$username = $_SESSION['username'];
$query = "SELECT tipe FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}






date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;



function getUserName($conn, $user_id)
{
    $stmt = $conn->prepare("SELECT nama FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->bind_result($nama);
    $stmt->fetch();
    $stmt->close();
    return $nama ?: '-';
}

function getUnitName($conn, $unit_id)
{
    $stmt = $conn->prepare("SELECT unit_name FROM unit WHERE id = ?");
    $stmt->bind_param("i", $unit_id);
    $stmt->execute();
    $stmt->bind_result($unit_name);
    $stmt->fetch();
    $stmt->close();
    return $unit_name ?: '-';
}




// Ambil data user_unit dengan search nama user / nama unit
function getUserUnitSearch($conn, $limit, $page, $search, $order = 'nama ASC')
{
    $offset = ($page - 1) * $limit;
    $whereClause = '';
    if (!empty($search)) {
        $esc = $conn->real_escape_string($search);
        $whereClause = "WHERE u.nama LIKE '%$esc%' OR un.unit_name LIKE '%$esc%'";
    }

    // Hitung total user unik
    $countSql = "
        SELECT COUNT(DISTINCT u.id) 
        FROM user_unit uu
        LEFT JOIN users u ON uu.user_id = u.id
        LEFT JOIN unit un ON uu.unit_id = un.id
        $whereClause
    ";
    $total = $conn->query($countSql)->fetch_row()[0];

    // Ambil data user unik + gabungkan unit jadi 1 kolom
    $sql = "
        SELECT 
            u.id AS user_id,
            u.nama,
            GROUP_CONCAT(DISTINCT un.unit_name ORDER BY un.unit_name SEPARATOR ', ') AS unit_names,
            MIN(uu.created_at) AS created_at -- ambil tanggal terlama
        FROM user_unit uu
        LEFT JOIN users u ON uu.user_id = u.id
        LEFT JOIN unit un ON uu.unit_id = un.id
        $whereClause
        GROUP BY u.id, u.nama
        ORDER BY $order
        LIMIT $offset, $limit
    ";
    $data = $conn->query($sql);

    $totalPages = ($limit > 0 && $limit != PHP_INT_MAX) ? ceil($total / $limit) : 1;

    return ['data' => $data, 'totalPages' => $totalPages, 'totalRows' => $total];
}


// Ambil data approval_chain dengan search nama user / approver / unit
function getApprovalChainSearch($conn, $limit, $page, $search, $order = 'ac.id ASC')
{
    $offset = ($page - 1) * $limit;
    $whereClause = '';
    if (!empty($search)) {
        $esc = $conn->real_escape_string($search);
        $whereClause = "WHERE u.nama LIKE '%$esc%' 
                        OR a.nama LIKE '%$esc%' 
                        OR un.unit_name LIKE '%$esc%'";
    }

    // Hitung total data
    $countSql = "
        SELECT COUNT(*) 
        FROM approval_chain ac
        LEFT JOIN users u ON ac.user_id = u.id
        LEFT JOIN users a ON ac.approver_id = a.id
        LEFT JOIN unit un ON ac.unit_id = un.id
        $whereClause
    ";
    $total = $conn->query($countSql)->fetch_row()[0];

    // Ambil data
    $sql = "
        SELECT ac.*, u.nama AS user_nama, a.nama AS approver_nama, un.unit_name, lo.id AS lo_id
        FROM approval_chain ac
        LEFT JOIN users u ON ac.user_id = u.id
        LEFT JOIN users a ON ac.approver_id = a.id
        LEFT JOIN unit un ON ac.unit_id = un.id
        LEFT JOIN letter_order lo ON lo.user_id = ac.user_id
        $whereClause
        ORDER BY $order
        LIMIT $offset, $limit
    ";
    $data = $conn->query($sql);

    $totalPages = ($limit > 0 && $limit != PHP_INT_MAX) ? ceil($total / $limit) : 1;

    return ['data' => $data, 'totalPages' => $totalPages, 'totalRows' => $total];
}

function getSearchData($conn, $table, $fields, $limit, $page, $search, $order = 'id ASC')
{
    $offset = ($page - 1) * $limit;
    $whereClause = '';
    if (!empty($search)) {
        $likeClauses = [];
        foreach ($fields as $field) {
            $likeClauses[] = "$field LIKE '%" . $conn->real_escape_string($search) . "%'";
        }
        $whereClause = 'WHERE ' . implode(' OR ', $likeClauses);
    }

    $total = $conn->query("SELECT COUNT(*) FROM $table $whereClause")->fetch_row()[0];
    $sql = "SELECT * FROM $table $whereClause ORDER BY $order LIMIT $offset, $limit";
    $data = $conn->query($sql);
    $totalPages = ceil($total / $limit);
    return ['data' => $data, 'totalPages' => $totalPages, 'totalRows' => $total];
}

function renderPagination($key, $totalPages, $page, $limit, $search)
{
    if ($totalPages <= 1) return;
    echo '<nav aria-label="Page navigation"><ul class="pagination justify-content-center mt-3">';
    echo '<li class="page-item ' . ($page <= 1 ? 'disabled' : '') . '">';
    echo '<a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . max(1, $page - 1) . '">Prev</a></li>';
    for ($i = 1; $i <= $totalPages; $i++) {
        $active = ($page == $i) ? 'active' : '';
        echo '<li class="page-item ' . $active . '"><a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . $i . '">' . $i . '</a></li>';
    }
    echo '<li class="page-item ' . ($page >= $totalPages ? 'disabled' : '') . '">';
    echo '<a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . min($totalPages, $page + 1) . '">Next</a></li>';
    echo '</ul></nav>';
}

$profil_limit = isset($_GET['limit_profil']) ? ($_GET['limit_profil'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_profil']) : 5;
$profil_page = isset($_GET['page_profil']) ? (int)$_GET['page_profil'] : 1;
$search_profil = isset($_GET['search_profil']) ? $_GET['search_profil'] : '';

$misi_limit = isset($_GET['limit_misi']) ? ($_GET['limit_misi'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_misi']) : 5;
$misi_page = isset($_GET['page_misi']) ? (int)$_GET['page_misi'] : 1;
$search_misi = isset($_GET['search_misi']) ? $_GET['search_misi'] : '';

$nilai_limit = isset($_GET['limit_nilai']) ? ($_GET['limit_nilai'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_nilai']) : 5;
$nilai_page = isset($_GET['page_nilai']) ? (int)$_GET['page_nilai'] : 1;
$search_nilai = isset($_GET['search_nilai']) ? $_GET['search_nilai'] : '';

$jejak_limit = isset($_GET['limit_jejak']) ? ($_GET['limit_jejak'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_jejak']) : 5;
$jejak_page = isset($_GET['page_jejak']) ? (int)$_GET['page_jejak'] : 1;
$search_jejak = isset($_GET['search_jejak']) ? $_GET['search_jejak'] : '';




$userUnit = getUserUnitSearch($conn, $profil_limit, $profil_page, $search_profil, 'uu.id ASC');


$approvalChain = getApprovalChainSearch($conn, $misi_limit, $misi_page, $search_misi, 'ac.id ASC');

$nilai = getSearchData($conn, 'pelaporan', ['isi_pelaporan'], $nilai_limit, $nilai_page, $search_nilai, 'created_at ASC');

$jejak = getSearchData($conn, 'dokumen', ['isi_dokumen'], $jejak_limit, $jejak_page, $search_jejak, 'created_at ASC');

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="img/baru/logojp.png" rel="icon">

    <title>Manajemen Alur To Do List</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        .pagination .page-link {
            color: #007bff;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }

        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 7px 9px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 190px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 7px 13px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .custom-filter {
            border-radius: 15px;
            width: 151px;
            background-color: #001eff;
            color: #ffc107;
            border: 1px solid #ced4da;
            font-weight: 500;
            margin-right: 0px;
            transition: background-color 0.3s ease;
        }

        .custom-filter:focus {
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            outline: none;
            color: #001eff;
        }

        .custom-filter option {
            color: #001eff;
            background-color: #fff;
        }
    </style>
</head>

<body>
    <div class="d-flex">

        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu" aria-expanded="false">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle active" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php" class="active"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="manajemen-surat.php"><i class="fas fa-folder-open"></i> Manajemen Data Surat</a>
            <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
            <a href="manage-inisial.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'manage-inisial.php') ? 'active' : ''; ?>"><i class="fas fa-signature"></i> Manajemen Inisial</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu" aria-expanded="false">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>

            <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>

        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>Manajemen data user To Do List</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit_profil" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ([5, 20, 'All'] as $opt): ?>
                                <option value="<?= $opt ?>" <?= $profil_limit == ($opt === 'All' ? PHP_INT_MAX : $opt) ? 'selected' : '' ?>><?= $opt ?></option>
                            <?php endforeach; ?>
                        </select>
                        <input type="hidden" name="search_profil" value="<?= htmlspecialchars($search_profil) ?>">
                        <input type="hidden" name="page_profil" value="1">
                    </form>

                    <form method="get" class="search-box-new d-flex align-items-center">
                        <input type="text" id="searchInputNew" name="search_profil" class="search-input-new form-control form-control-sm me-1" placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($search_profil) ?>">
                        <input type="hidden" name="profil_limit" value="<?= $profil_limit ?>">
                        <button type="submit" id="searchButtonNew" class="search-btn-new btn btn-primary btn-sm"><i class="fas fa-search"></i> Cari</button>
                    </form>
                </div>
                <div>
                    <a href="add/add_user_unit.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Tambah User Unit</a>
                </div>
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>ID</th>
                        <th>Nama User</th>
                        <th>Nama Unit</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($userUnit['data']->num_rows > 0): ?>
                        <?php while ($row = $userUnit['data']->fetch_assoc()): ?>
                            <tr class="text-center">
                                <td><?= $row['user_id'] ?></td>
                                <td><?= htmlspecialchars($row['nama']) ?></td>
                                <td><?= htmlspecialchars($row['unit_names']) ?></td>
                                <td><?= htmlspecialchars($row['created_at']) ?></td>
                                <td>
                                    <a href="edit/edit_user_unit.php?id=<?php echo $row['user_id']; ?>"
                                        class="btn btn-warning btn-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>

                                    <a href="delete/delete_user_unit.php?id=<?php echo $row['user_id']; ?>"
                                        class="btn btn-danger btn-sm"
                                        onclick="return confirm('Hapus data ini?')">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>

                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center">Tidak ada data</td>
                        </tr>
                    <?php endif; ?>

                </tbody>
            </table>
            <?php renderPagination('profil', $userUnit['totalPages'], $profil_page, $profil_limit, $search_profil); ?>

            <hr>

            <h2>Manajemen preview To Do List</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit_misi" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ([5, 20, 'All'] as $opt): ?>
                                <option value="<?= $opt ?>" <?= $misi_limit == ($opt === 'All' ? PHP_INT_MAX : $opt) ? 'selected' : '' ?>><?= $opt ?></option>
                            <?php endforeach; ?>
                        </select>
                        <input type="hidden" name="search_misi" value="<?= htmlspecialchars($search_misi) ?>">
                        <input type="hidden" name="page_misi" value="1">
                    </form>

                    <form method="get" class="search-box-new d-flex align-items-center">
                        <input type="text" id="searchInputNew1" name="search_misi" class="search-input-new form-control form-control-sm me-1" placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($search_misi) ?>">
                        <input type="hidden" name="misi_limit" value="<?= $misi_limit ?>">
                        <button type="submit" id="searchButtonNew1" class="search-btn-new btn btn-primary btn-sm"><i class="fas fa-search"></i> Cari</button>
                    </form>
                </div>
                <div>
                    <a href="add-letter-order.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Tambah Urutan</a>
                </div>
            </div>


            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>ID</th>
                        <th>Nama User</th>
                        <th>Nama Atasan (Approver)</th>
                        <th>Asal Unit</th>
                        <th>Urutan Ke</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($approvalChain['data']->num_rows > 0): ?>
                        <?php while ($row = $approvalChain['data']->fetch_assoc()): ?>
                            <tr class="text-center">
                                <td><?= $row['id'] ?></td>
                                <td><?= htmlspecialchars($row['user_nama']) ?></td>
                                <td><?= htmlspecialchars($row['approver_nama']) ?></td>
                                <td><?= htmlspecialchars($row['unit_name']) ?></td>
                                <td><?= htmlspecialchars($row['urutan']) ?></td>
                                <td><?= htmlspecialchars($row['created_at']) ?></td>
                                <td>
                                    <?php
                                    // If letter_order mapping exists, link to edit; otherwise link to add mapping
                                    $loId = isset($row['lo_id']) ? (int)$row['lo_id'] : null;
                                    if ($loId):
                                    ?>
                                        <a href="edit-letter-order.php?id=<?= $loId ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                    <?php else: ?>
                                        <a href="add-letter-order.php?user_id=<?= (int)$row['user_id'] ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                    <?php endif; ?>
                                    <form method="POST" action="<?= $loId ? 'edit-letter-order.php?id=' . $loId : 'add-letter-order.php?user_id=' . (int)$row['user_id'] ?>" style="display:inline;">
                                        <input type="hidden" name="chain_action" value="delete">
                                        <input type="hidden" name="chain_id" value="<?= (int)$row['id'] ?>">
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Hapus data ini?')"><i class="fas fa-trash-alt"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="text-center">Tidak ada data</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <?php renderPagination('misi', $approvalChain['totalPages'], $misi_page, $misi_limit, $search_misi); ?>


        </div>
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
        <script>
            const searchInputNew = document.getElementById('searchInputNew');
            const searchButtonNew = document.getElementById('searchButtonNew');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew.addEventListener('focus', function() {
                searchButtonNew.classList.add('show'); // Tampilkan tombol
                searchInputNew.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew.addEventListener('blur', function() {
                if (!searchInputNew.value.trim()) {
                    searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew1 = document.getElementById('searchInputNew1');
            const searchButtonNew1 = document.getElementById('searchButtonNew1');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew1.addEventListener('focus', function() {
                searchButtonNew1.classList.add('show'); // Tampilkan tombol
                searchInputNew1.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew1.addEventListener('blur', function() {
                if (!searchInputNew1.value.trim()) {
                    searchButtonNew1.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew1.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew2 = document.getElementById('searchInputNew2');
            const searchButtonNew2 = document.getElementById('searchButtonNew2');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew2.addEventListener('focus', function() {
                searchButtonNew2.classList.add('show'); // Tampilkan tombol
                searchInputNew2.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew2.addEventListener('blur', function() {
                if (!searchInputNew2.value.trim()) {
                    searchButtonNew2.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew2.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew3 = document.getElementById('searchInputNew3');
            const searchButtonNew3 = document.getElementById('searchButtonNew3');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew3.addEventListener('focus', function() {
                searchButtonNew3.classList.add('show'); // Tampilkan tombol
                searchInputNew3.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew3.addEventListener('blur', function() {
                if (!searchInputNew3.value.trim()) {
                    searchButtonNew3.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew3.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });
        </script>
</body>

</html>