<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

// Cek apakah tipe user adalah admin
$username = $_SESSION['username'];
$query = "SELECT tipe FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'admin') {
    // Redirect jika bukan admin
    header('Location: ../login.php');
    exit();
}




date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;

// Ambil parameter pencarian
$search = $_GET['search'] ?? '';
$searchQuery = "";
$searchParams = [];
$types = "";

// Sort
$sort_by = $_GET['sort_by'] ?? 'created_at';
$sort_order = $_GET['sort_order'] ?? 'DESC';
$allowedSort = [
    'agenda' => 'agenda.agenda',
    'tanggal' => 'agenda.tanggal',
    'waktu' => 'agenda.waktu',
    'tempat' => 'agenda.tempat',
    'pic' => 'users.nama',
    'keterangan' => 'agenda.keterangan',
    'created_at' => 'agenda.created_at'
];
$sort_column = $allowedSort[$sort_by] ?? 'agenda.created_at';
$next_order = ($sort_order === 'ASC') ? 'DESC' : 'ASC';

function sortableHeader($label, $key, $currentSortBy, $currentOrder, $get)
{
    $nextOrder = ($currentSortBy === $key && $currentOrder === 'ASC') ? 'DESC' : 'ASC';
    $icon = '<i class="fas fa-sort ms-1"></i>';
    if ($currentSortBy === $key) {
        $icon = $currentOrder === 'ASC'
            ? '<i class="fas fa-arrow-up ms-1"></i>'
            : '<i class="fas fa-arrow-down ms-1"></i>';
    }
    $params = array_merge($get, ['sort_by' => $key, 'sort_order' => $nextOrder]);
    $link = '?' . http_build_query($params);
    return "<a href=\"$link\" class=\"text-warning text-decoration-none\">$label $icon</a>";
}

// WHERE clause
$baseWhere = "1";
if (!empty($search)) {
    $baseWhere .= " AND (agenda.agenda LIKE CONCAT('%', ?, '%') OR agenda.tempat LIKE CONCAT('%', ?, '%') OR agenda.keterangan LIKE CONCAT('%', ?, '%') OR users.nama LIKE CONCAT('%', ?, '%'))";
    $searchParams = array_fill(0, 4, $search);
    $types .= str_repeat("s", 4);
}

// Pagination
$limitOptions = [20, 100, 'All'];
$selectedLimit = $_GET['limit'] ?? 20;
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;

// Hitung total
$countSql = "SELECT COUNT(*) as total FROM agenda LEFT JOIN users ON agenda.pic = users.id WHERE $baseWhere";
$countStmt = $conn->prepare($countSql);
if (!empty($search)) {
    $countStmt->bind_param($types, ...$searchParams);
}
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$totalRows = $countResult['total'] ?? 0;

// Offset
if ($selectedLimit === 'All') {
    $limit = $totalRows;
    $offset = 0;
} else {
    $limit = (int)$selectedLimit;
    $offset = ($page - 1) * $limit;
}

$totalPages = ($selectedLimit === 'All') ? 1 : ceil($totalRows / $limit);

// Ambil data
$sql = "
    SELECT agenda.*, users.nama 
    FROM agenda 
    LEFT JOIN users ON agenda.pic = users.id 
    WHERE $baseWhere 
    ORDER BY $sort_column $sort_order 
    LIMIT ? OFFSET ?
";
$stmt = $conn->prepare($sql);
$allParams = array_merge($searchParams, [$limit, $offset]);
$types .= "ii";
$stmt->bind_param($types, ...$allParams);
$stmt->execute();
$agenda = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="img/baru/logojp.png" rel="icon">

    <title>Record Agenda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        .pagination .page-link {
            color: #007bff;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }

        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 7px 9px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 190px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 7px 13px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .custom-filter {
            border-radius: 15px;
            width: 151px;
            background-color: #001eff;
            color: #ffc107;
            border: 1px solid #ced4da;
            font-weight: 500;
            margin-right: 0px;
            transition: background-color 0.3s ease;
        }

        .custom-filter:focus {
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            outline: none;
            color: #001eff;
        }

        .custom-filter option {
            color: #001eff;
            background-color: #fff;
        }
    </style>
</head>

<body>
    <div class="d-flex">

        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu" aria-expanded="false">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle active" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php" class="active">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="manajemen-surat.php"><i class="fas fa-folder-open"></i> Manajemen Data Surat</a>
            <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu" aria-expanded="false">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>

            <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>Record Agenda</h2>
            <div class="d-flex justify-content-between align-items-center mb-2">
                <form method="get" class="d-flex align-items-center mb-0">
                    <label class="me-2 fw-bold">Show</label>
                    <select name="limit" onchange="this.form.submit()" class="form-select form-select-sm w-auto me-2">
                        <?php foreach ($limitOptions as $option): ?>
                            <option value="<?= $option ?>" <?= $selectedLimit == $option ? 'selected' : '' ?>>
                                <?= $option ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>

                <div class="d-flex align-items-center">
                    <!-- Form Pencarian -->
                    <form method="GET" action="" class="search-box-new me-0 mb-0">
                        <input
                            type="text"
                            id="searchInputNew"
                            name="search"
                            class="search-input-new me-1"
                            placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
                        <button type="submit" id="searchButtonNew" class="search-btn-new">
                            <i class="fas fa-search"></i> Cari
                        </button>
                    </form>
                </div>

            </div>


            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>No</th>
                        <th><?= sortableHeader('Uraian Agenda', 'agenda', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Tanggal', 'tanggal', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Waktu', 'waktu', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Tempat', 'tempat', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('PIC', 'pic', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Keterangan', 'keterangan', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Dibuat', 'created_at', $sort_by, $sort_order, $_GET) ?></th>
                        <!-- <th><i class="fas fa-clock"></i></th> -->
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = ($page - 1) * ($selectedLimit === 'All' ? $totalRows : (int)$selectedLimit) + 1;
                    date_default_timezone_set('Asia/Jakarta'); // Pastikan zona waktu WIB
                    $nowDate = date('Y-m-d');
                    $nowTime = date('H:i');
                    while ($row = $agenda->fetch_assoc()):
                        $agendaDate = $row['tanggal'];
                        $agendaTime = $row['waktu'];

                        // Tentukan status agenda
                        $statusIcon = '<i class="fas fa-calendar-alt fa-lg text-secondary"></i>'; // Default

                        if ($agendaDate < $nowDate || ($agendaDate == $nowDate && $agendaTime < $nowTime)) {
                            // Sudah lewat
                            $statusIcon = '<i class="fas fa-ban fa-lg text-danger" title="Sudah lewat"></i>';
                        } elseif ($agendaDate == $nowDate && $agendaTime >= $nowTime) {
                            // Hari ini (waktu belum lewat)
                            $statusIcon = '<i class="fas fa-clock fa-lg text-warning" title="Hari ini"></i>';
                        } else {
                            // Akan datang (tanggal lebih besar dari hari ini)
                            $statusIcon = '<i class="fas fa-calendar-check fa-lg text-success" title="Akan datang"></i>';
                        }

                    ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td><?= htmlspecialchars($row['agenda']) ?></td>
                            <td class="text-center"><?= htmlspecialchars($agendaDate) ?></td>
                            <td class="text-center"><?= htmlspecialchars($agendaTime) ?></td>
                            <td><?= htmlspecialchars($row['tempat']) ?></td>
                            <td><?= htmlspecialchars($row['nama'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($row['keterangan']) ?></td>
                            <td class="text-center"><?= $row['created_at'] ?></td>
                            <!-- <td class="text-center">
                            <?= $statusIcon ?>
                        </td> -->
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

            <?php if ($totalPages > 1): ?>
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center mt-3">
                        <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => max(1, $page - 1)])) ?>">Prev</a>
                        </li>
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= $page == $i ? 'active' : '' ?>">
                                <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => min($totalPages, $page + 1)])) ?>">Next</a>
                        </li>
                    </ul>
                </nav>
            <?php endif; ?>




        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>



    <script>
        const searchInputNew = document.getElementById('searchInputNew');
        const searchButtonNew = document.getElementById('searchButtonNew');

        // Event listener untuk memperlihatkan tombol ketika input diklik
        searchInputNew.addEventListener('focus', function() {
            searchButtonNew.classList.add('show'); // Tampilkan tombol
            searchInputNew.placeholder = ''; // Hilangkan placeholder
        });

        // Event listener untuk menyembunyikan tombol ketika input kosong
        searchInputNew.addEventListener('blur', function() {
            if (!searchInputNew.value.trim()) {
                searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
            }
        });
    </script>
</body>

</html>