<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

// Cek apakah tipe user adalah admin
$username = $_SESSION['username'];
$query = "SELECT tipe FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}

date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif
$countQuery = "SELECT COUNT(*) as jumlah FROM agenda WHERE tanggal > ? OR (tanggal = ? AND waktu >= ?)";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;

// Active tab
$activeTab = $_GET['tab'] ?? 'klasifikasi';

// Messages
$success = $_GET['success'] ?? '';
$error = $_GET['error'] ?? '';

// ===== Klasifikasi Persuratan CRUD =====
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tambah_klasifikasi'])) {
    $kode = strtoupper(trim($_POST['kode']));
    $nama = trim($_POST['nama']);

    $stmt = $conn->prepare("INSERT INTO klasifikasi_arsip (kode, nama) VALUES (?, ?)");
    $stmt->bind_param("ss", $kode, $nama);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=klasifikasi&success=Klasifikasi berhasil ditambahkan");
    } else {
        header("Location: manajemen-surat.php?tab=klasifikasi&error=Gagal menambahkan klasifikasi");
    }
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_klasifikasi'])) {
    $id = $_POST['id'];
    $kode = strtoupper(trim($_POST['kode']));
    $nama = trim($_POST['nama']);

    $stmt = $conn->prepare("UPDATE klasifikasi_arsip SET kode = ?, nama = ? WHERE id = ?");
    $stmt->bind_param("ssi", $kode, $nama, $id);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=klasifikasi&success=Klasifikasi berhasil diupdate");
    } else {
        header("Location: manajemen-surat.php?tab=klasifikasi&error=Gagal mengupdate klasifikasi");
    }
    exit();
}

if (isset($_GET['delete_klasifikasi'])) {
    $id = $_GET['delete_klasifikasi'];
    $stmt = $conn->prepare("DELETE FROM klasifikasi_arsip WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=klasifikasi&success=Klasifikasi berhasil dihapus");
    } else {
        header("Location: manajemen-surat.php?tab=klasifikasi&error=Gagal menghapus klasifikasi");
    }
    exit();
}

// ===== JENIS SURAT CRUD =====
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tambah_jenis'])) {
    $kode = strtoupper(trim($_POST['kode']));
    $nama = trim($_POST['nama']);
    $id_klasifikasi = !empty($_POST['id_klasifikasi']) ? $_POST['id_klasifikasi'] : null;

    $stmt = $conn->prepare("INSERT INTO jenis_surat (kode, nama, id_klasifikasi) VALUES (?, ?, ?)");
    $stmt->bind_param("ssi", $kode, $nama, $id_klasifikasi);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=jenis&success=Jenis surat berhasil ditambahkan");
    } else {
        header("Location: manajemen-surat.php?tab=jenis&error=Gagal menambahkan jenis surat");
    }
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_jenis'])) {
    $id = $_POST['id'];
    $kode = strtoupper(trim($_POST['kode']));
    $nama = trim($_POST['nama']);
    $id_klasifikasi = !empty($_POST['id_klasifikasi']) ? $_POST['id_klasifikasi'] : null;

    $stmt = $conn->prepare("UPDATE jenis_surat SET kode = ?, nama = ?, id_klasifikasi = ? WHERE id = ?");
    $stmt->bind_param("ssii", $kode, $nama, $id_klasifikasi, $id);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=jenis&success=Jenis surat berhasil diupdate");
    } else {
        header("Location: manajemen-surat.php?tab=jenis&error=Gagal mengupdate jenis surat");
    }
    exit();
}

if (isset($_GET['delete_jenis'])) {
    $id = $_GET['delete_jenis'];
    $stmt = $conn->prepare("DELETE FROM jenis_surat WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=jenis&success=Jenis surat berhasil dihapus");
    } else {
        header("Location: manajemen-surat.php?tab=jenis&error=Gagal menghapus jenis surat");
    }
    exit();
}

// ===== SUBJENIS SURAT CRUD =====
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tambah_subjenis'])) {
    $kode = strtoupper(trim($_POST['kode']));
    $nama = trim($_POST['nama']);
    $id_jenis = $_POST['id_jenis'];
    $id_klasifikasi = $_POST['id_klasifikasi'];

    $stmt = $conn->prepare("INSERT INTO subjenis_surat (kode, nama, id_jenis, id_klasifikasi) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssii", $kode, $nama, $id_jenis, $id_klasifikasi);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=subjenis&success=Subjenis surat berhasil ditambahkan");
    } else {
        header("Location: manajemen-surat.php?tab=subjenis&error=Gagal menambahkan subjenis surat");
    }
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_subjenis'])) {
    $id = $_POST['id'];
    $kode = strtoupper(trim($_POST['kode']));
    $nama = trim($_POST['nama']);
    $id_jenis = $_POST['id_jenis'];
    $id_klasifikasi = $_POST['id_klasifikasi'];

    $stmt = $conn->prepare("UPDATE subjenis_surat SET kode = ?, nama = ?, id_jenis = ?, id_klasifikasi = ? WHERE id = ?");
    $stmt->bind_param("ssiii", $kode, $nama, $id_jenis, $id_klasifikasi, $id);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=subjenis&success=Subjenis surat berhasil diupdate");
    } else {
        header("Location: manajemen-surat.php?tab=subjenis&error=Gagal mengupdate subjenis surat");
    }
    exit();
}

if (isset($_GET['delete_subjenis'])) {
    $id = $_GET['delete_subjenis'];
    $stmt = $conn->prepare("DELETE FROM subjenis_surat WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        header("Location: manajemen-surat.php?tab=subjenis&success=Subjenis surat berhasil dihapus");
    } else {
        header("Location: manajemen-surat.php?tab=subjenis&error=Gagal menghapus subjenis surat");
    }
    exit();
}

// Fetch data
$klasifikasiData = $conn->query("SELECT * FROM klasifikasi_arsip ORDER BY kode ASC");
$jenisData = $conn->query("SELECT js.*, ka.nama as klasifikasi_nama FROM jenis_surat js LEFT JOIN klasifikasi_arsip ka ON js.id_klasifikasi = ka.id ORDER BY js.kode ASC");
$subjenisData = $conn->query("SELECT ss.*, js.nama as jenis_nama, ka.nama as klasifikasi_nama FROM subjenis_surat ss LEFT JOIN jenis_surat js ON ss.id_jenis = js.id LEFT JOIN klasifikasi_arsip ka ON ss.id_klasifikasi = ka.id ORDER BY ss.kode ASC");

// For dropdowns
$klasifikasiList = $conn->query("SELECT * FROM klasifikasi_arsip ORDER BY nama ASC");
$jenisListForSubjenis = $conn->query("SELECT * FROM jenis_surat ORDER BY nama ASC");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">
    <title>Manajemen Data Surat</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        .table thead {
            background-color: #0047ab;
            color: #ffc107;
            text-transform: uppercase;
            font-weight: bold;
        }

        .table thead th {
            background-color: #0c50e1;
            color: #ffc107;
        }

        .nav-tabs .nav-link.active {
            background-color: #0c50e1;
            color: #ffc107;
            font-weight: bold;
        }

        .nav-tabs .nav-link {
            color: #0c50e1;
        }

        .sidebar .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar .submenu {
            padding-left: 20px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar .submenu a {
            font-size: 14px;
            padding: 8px 10px;
        }

        .sidebar .arrow-icon {
            margin-left: 5px;
            transition: transform 0.3s ease;
        }

        .sidebar .submenu-toggle[aria-expanded="true"] .arrow-icon {
            transform: rotate(180deg);
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu" aria-expanded="false">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
                <a href="manajemen-surat.php" class="active"><i class="fas fa-cog"></i> Manajemen Data Surat</a>
                <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
                <a href="manage-inisial.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'manage-inisial.php') ? 'active' : ''; ?>"><i class="fas fa-signature"></i> Manajemen Inisial</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu" aria-expanded="false">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>


            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <div
                class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Manajemen Data Surat</h1>
            </div>

            <?php if ($success): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?= htmlspecialchars($success) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?= htmlspecialchars($error) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Tabs -->
            <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link <?= $activeTab == 'klasifikasi' ? 'active' : '' ?>" href="?tab=klasifikasi">
                        <i class="fas fa-tags"></i> Klasifikasi Persuratan
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link <?= $activeTab == 'jenis' ? 'active' : '' ?>" href="?tab=jenis">
                        <i class="fas fa-list"></i> Jenis Surat
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link <?= $activeTab == 'subjenis' ? 'active' : '' ?>" href="?tab=subjenis">
                        <i class="fas fa-sitemap"></i> Subjenis Surat
                    </a>
                </li>
            </ul>

            <div class="tab-content" id="myTabContent">

                <!-- Klasifikasi Persuratan TAB -->
                <?php if ($activeTab == 'klasifikasi'): ?>
                    <div class="tab-pane fade show active">
                        <div class="d-flex justify-content-between mb-3">
                            <h4>Data Klasifikasi Persuratan</h4>
                            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalTambahKlasifikasi">
                                <i class="fas fa-plus"></i> Tambah Klasifikasi
                            </button>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode</th>
                                        <th>Nama Klasifikasi</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = 1;
                                    while ($row = $klasifikasiData->fetch_assoc()):
                                    ?>
                                        <tr>
                                            <td><?= $no++ ?></td>
                                            <td><span class="badge bg-primary"><?= htmlspecialchars($row['kode']) ?></span>
                                            </td>
                                            <td><?= htmlspecialchars($row['nama']) ?></td>
                                            <td>
                                                <button class="btn btn-sm btn-warning"
                                                    onclick="editKlasifikasi(<?= $row['id'] ?>, '<?= htmlspecialchars($row['kode']) ?>', '<?= htmlspecialchars($row['nama']) ?>')">
                                                    <i class="fas fa-edit"></i> Edit
                                                </button>
                                                <a href="?tab=klasifikasi&delete_klasifikasi=<?= $row['id'] ?>"
                                                    class="btn btn-sm btn-danger"
                                                    onclick="return confirm('Yakin ingin menghapus?')">
                                                    <i class="fas fa-trash"></i> Hapus
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- JENIS SURAT TAB -->
                <?php if ($activeTab == 'jenis'): ?>
                    <div class="tab-pane fade show active">
                        <div class="d-flex justify-content-between mb-3">
                            <h4>Data Jenis Surat</h4>
                            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalTambahJenis">
                                <i class="fas fa-plus"></i> Tambah Jenis Surat
                            </button>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode</th>
                                        <th>Nama Jenis Surat</th>
                                        <th>Klasifikasi</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = 1;
                                    while ($row = $jenisData->fetch_assoc()):
                                    ?>
                                        <tr>
                                            <td><?= $no++ ?></td>
                                            <td><span class="badge bg-info"><?= htmlspecialchars($row['kode']) ?></span>
                                            </td>
                                            <td><?= htmlspecialchars($row['nama']) ?></td>
                                            <td><?= $row['klasifikasi_nama'] ? htmlspecialchars($row['klasifikasi_nama']) : '<em class="text-muted">-</em>' ?>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-warning"
                                                    onclick="editJenis(<?= $row['id'] ?>, '<?= htmlspecialchars($row['kode']) ?>', '<?= htmlspecialchars($row['nama']) ?>', <?= $row['id_klasifikasi'] ?? 'null' ?>)">
                                                    <i class="fas fa-edit"></i> Edit
                                                </button>
                                                <a href="?tab=jenis&delete_jenis=<?= $row['id'] ?>"
                                                    class="btn btn-sm btn-danger"
                                                    onclick="return confirm('Yakin ingin menghapus?')">
                                                    <i class="fas fa-trash"></i> Hapus
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- SUBJENIS SURAT TAB -->
                <?php if ($activeTab == 'subjenis'): ?>
                    <div class="tab-pane fade show active">
                        <div class="d-flex justify-content-between mb-3">
                            <h4>Data Subjenis Surat</h4>
                            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalTambahSubjenis">
                                <i class="fas fa-plus"></i> Tambah Subjenis Surat
                            </button>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode</th>
                                        <th>Nama Subjenis Surat</th>
                                        <th>Jenis Surat</th>
                                        <th>Klasifikasi</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = 1;
                                    while ($row = $subjenisData->fetch_assoc()):
                                    ?>
                                        <tr>
                                            <td><?= $no++ ?></td>
                                            <td><span class="badge bg-success"><?= htmlspecialchars($row['kode']) ?></span>
                                            </td>
                                            <td><?= htmlspecialchars($row['nama']) ?></td>
                                            <td><?= htmlspecialchars($row['jenis_nama'] ?? '-') ?></td>
                                            <td><?= htmlspecialchars($row['klasifikasi_nama'] ?? '-') ?></td>
                                            <td>
                                                <button class="btn btn-sm btn-warning"
                                                    onclick="editSubjenis(<?= $row['id'] ?>, '<?= htmlspecialchars($row['kode']) ?>', '<?= htmlspecialchars($row['nama']) ?>', <?= $row['id_jenis'] ?>, <?= $row['id_klasifikasi'] ?>)">
                                                    <i class="fas fa-edit"></i> Edit
                                                </button>
                                                <a href="?tab=subjenis&delete_subjenis=<?= $row['id'] ?>"
                                                    class="btn btn-sm btn-danger"
                                                    onclick="return confirm('Yakin ingin menghapus?')">
                                                    <i class="fas fa-trash"></i> Hapus
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
            </main>
        </div>
    </div>

    <!-- Modal Tambah Klasifikasi -->
    <div class="modal fade" id="modalTambahKlasifikasi" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Klasifikasi Persuratan</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Kode <span class="text-danger">*</span></label>
                            <input type="text" name="kode" class="form-control" required maxlength="10">
                            <small class="text-muted">Contoh: PR, MM, OT</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama Klasifikasi <span class="text-danger">*</span></label>
                            <input type="text" name="nama" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="tambah_klasifikasi" class="btn btn-success">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Edit Klasifikasi -->
    <div class="modal fade" id="modalEditKlasifikasi" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="id" id="edit_klasifikasi_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Klasifikasi Persuratan</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Kode <span class="text-danger">*</span></label>
                            <input type="text" name="kode" id="edit_klasifikasi_kode" class="form-control" required
                                maxlength="10">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama Klasifikasi <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="edit_klasifikasi_nama" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="edit_klasifikasi" class="btn btn-warning">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Tambah Jenis -->
    <div class="modal fade" id="modalTambahJenis" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Jenis Surat</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Kode <span class="text-danger">*</span></label>
                            <input type="text" name="kode" class="form-control" required maxlength="10">
                            <small class="text-muted">Contoh: 01, 02, 03</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama Jenis Surat <span class="text-danger">*</span></label>
                            <input type="text" name="nama" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Klasifikasi Persuratan</label>
                            <select name="id_klasifikasi" class="form-select">
                                <option value="">-- Pilih Klasifikasi (Opsional) --</option>
                                <?php
                                $klasifikasiList->data_seek(0);
                                while ($k = $klasifikasiList->fetch_assoc()):
                                ?>
                                    <option value="<?= $k['id'] ?>"><?= htmlspecialchars($k['kode']) ?> -
                                        <?= htmlspecialchars($k['nama']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="tambah_jenis" class="btn btn-success">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Edit Jenis -->
    <div class="modal fade" id="modalEditJenis" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="id" id="edit_jenis_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Jenis Surat</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Kode <span class="text-danger">*</span></label>
                            <input type="text" name="kode" id="edit_jenis_kode" class="form-control" required
                                maxlength="10">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama Jenis Surat <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="edit_jenis_nama" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Klasifikasi Persuratan</label>
                            <select name="id_klasifikasi" id="edit_jenis_klasifikasi" class="form-select">
                                <option value="">-- Pilih Klasifikasi (Opsional) --</option>
                                <?php
                                $klasifikasiList->data_seek(0);
                                while ($k = $klasifikasiList->fetch_assoc()):
                                ?>
                                    <option value="<?= $k['id'] ?>"><?= htmlspecialchars($k['kode']) ?> -
                                        <?= htmlspecialchars($k['nama']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="edit_jenis" class="btn btn-warning">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Tambah Subjenis -->
    <div class="modal fade" id="modalTambahSubjenis" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Tambah Subjenis Surat</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Kode <span class="text-danger">*</span></label>
                            <input type="text" name="kode" class="form-control" required maxlength="10">
                            <small class="text-muted">Contoh: 01, 02, 03</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama Subjenis Surat <span class="text-danger">*</span></label>
                            <input type="text" name="nama" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Klasifikasi Persuratan <span class="text-danger">*</span></label>
                            <select name="id_klasifikasi" id="add_subjenis_klasifikasi" class="form-select" required
                                onchange="loadJenisForSubjenis(this.value, 'add')">
                                <option value="">-- Pilih Klasifikasi --</option>
                                <?php
                                $klasifikasiList->data_seek(0);
                                while ($k = $klasifikasiList->fetch_assoc()):
                                ?>
                                    <option value="<?= $k['id'] ?>"><?= htmlspecialchars($k['kode']) ?> -
                                        <?= htmlspecialchars($k['nama']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Jenis Surat <span class="text-danger">*</span></label>
                            <select name="id_jenis" id="add_subjenis_jenis" class="form-select" required>
                                <option value="">-- Pilih Klasifikasi Dulu --</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="tambah_subjenis" class="btn btn-success">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Edit Subjenis -->
    <div class="modal fade" id="modalEditSubjenis" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="id" id="edit_subjenis_id">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Subjenis Surat</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Kode <span class="text-danger">*</span></label>
                            <input type="text" name="kode" id="edit_subjenis_kode" class="form-control" required
                                maxlength="10">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama Subjenis Surat <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="edit_subjenis_nama" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Klasifikasi Persuratan <span class="text-danger">*</span></label>
                            <select name="id_klasifikasi" id="edit_subjenis_klasifikasi" class="form-select" required
                                onchange="loadJenisForSubjenis(this.value, 'edit')">
                                <option value="">-- Pilih Klasifikasi --</option>
                                <?php
                                $klasifikasiList->data_seek(0);
                                while ($k = $klasifikasiList->fetch_assoc()):
                                ?>
                                    <option value="<?= $k['id'] ?>"><?= htmlspecialchars($k['kode']) ?> -
                                        <?= htmlspecialchars($k['nama']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Jenis Surat <span class="text-danger">*</span></label>
                            <select name="id_jenis" id="edit_subjenis_jenis" class="form-select" required>
                                <option value="">-- Pilih Klasifikasi Dulu --</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="edit_subjenis" class="btn btn-warning">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function editKlasifikasi(id, kode, nama) {
            document.getElementById('edit_klasifikasi_id').value = id;
            document.getElementById('edit_klasifikasi_kode').value = kode;
            document.getElementById('edit_klasifikasi_nama').value = nama;
            new bootstrap.Modal(document.getElementById('modalEditKlasifikasi')).show();
        }

        function editJenis(id, kode, nama, id_klasifikasi) {
            document.getElementById('edit_jenis_id').value = id;
            document.getElementById('edit_jenis_kode').value = kode;
            document.getElementById('edit_jenis_nama').value = nama;
            document.getElementById('edit_jenis_klasifikasi').value = id_klasifikasi || '';
            new bootstrap.Modal(document.getElementById('modalEditJenis')).show();
        }

        function editSubjenis(id, kode, nama, id_jenis, id_klasifikasi) {
            document.getElementById('edit_subjenis_id').value = id;
            document.getElementById('edit_subjenis_kode').value = kode;
            document.getElementById('edit_subjenis_nama').value = nama;
            document.getElementById('edit_subjenis_klasifikasi').value = id_klasifikasi;

            // Load jenis first, then select
            loadJenisForSubjenis(id_klasifikasi, 'edit', id_jenis);

            new bootstrap.Modal(document.getElementById('modalEditSubjenis')).show();
        }

        async function loadJenisForSubjenis(klasifikasiId, mode, selectedJenisId = null) {
            const selectElement = mode === 'add' ?
                document.getElementById('add_subjenis_jenis') :
                document.getElementById('edit_subjenis_jenis');

            if (!klasifikasiId) {
                selectElement.innerHTML = '<option value="">-- Pilih Klasifikasi Dulu --</option>';
                return;
            }

            try {
                const response = await fetch(
                    `api_classification.php?action=get_jenis_by_klasifikasi&klasifikasi_id=${klasifikasiId}`);
                const data = await response.json();

                if (data.success) {
                    selectElement.innerHTML = '<option value="">-- Pilih Jenis Surat --</option>';
                    data.data.forEach(item => {
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = `${item.kode} - ${item.nama}`;
                        if (selectedJenisId && item.id == selectedJenisId) {
                            option.selected = true;
                        }
                        selectElement.appendChild(option);
                    });
                } else {
                    selectElement.innerHTML = '<option value="">-- Tidak ada jenis surat --</option>';
                }
            } catch (error) {
                console.error('Error loading jenis surat:', error);
                selectElement.innerHTML = '<option value="">-- Error loading data --</option>';
            }
        }

        // Submenu toggle functionality
        document.querySelectorAll('.submenu-toggle').forEach(toggle => {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                const targetId = this.getAttribute('href');
                const submenu = document.querySelector(targetId);

                if (submenu) {
                    if (submenu.classList.contains('show')) {
                        submenu.classList.remove('show');
                        this.setAttribute('aria-expanded', 'false');
                    } else {
                        // Close other submenus
                        document.querySelectorAll('.submenu.show').forEach(otherSubmenu => {
                            otherSubmenu.classList.remove('show');
                        });
                        document.querySelectorAll('.submenu-toggle[aria-expanded="true"]').forEach(
                            otherToggle => {
                                otherToggle.setAttribute('aria-expanded', 'false');
                            });

                        submenu.classList.add('show');
                        this.setAttribute('aria-expanded', 'true');
                    }
                }
            });
        });
    </script>
</body>

</html>