<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

// Cek apakah tipe user adalah admin
$username = $_SESSION['username'];
$query = "SELECT tipe, nama FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}

date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif
$countQuery = "SELECT COUNT(*) as jumlah FROM agenda WHERE tanggal > ? OR (tanggal = ? AND waktu >= ?)";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;

// Messages
$success = $_GET['success'] ?? '';
$error = $_GET['error'] ?? '';

// ===== CRUD Operations =====

// Add new inisial
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tambah_inisial'])) {
    $user_id = !empty($_POST['user_id']) ? (int)$_POST['user_id'] : null;
    $nama = trim($_POST['nama']);
    $inisial = trim($_POST['inisial']); // Allow lowercase - don't force uppercase

    if (empty($nama) || empty($inisial)) {
        header("Location: manage-inisial.php?error=Nama dan inisial harus diisi");
        exit();
    }

    $stmt = $conn->prepare("INSERT INTO inisial (user_id, nama, inisial, is_active) VALUES (?, ?, ?, 1)");
    $stmt->bind_param("iss", $user_id, $nama, $inisial);
    if ($stmt->execute()) {
        header("Location: manage-inisial.php?success=Inisial berhasil ditambahkan");
    } else {
        header("Location: manage-inisial.php?error=Gagal menambahkan inisial: " . $conn->error);
    }
    exit();
}

// Edit inisial
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_inisial'])) {
    $id = (int)$_POST['id'];
    $user_id = !empty($_POST['user_id']) ? (int)$_POST['user_id'] : null;
    $nama = trim($_POST['nama']);
    $inisial = trim($_POST['inisial']); // Allow lowercase - don't force uppercase
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    $stmt = $conn->prepare("UPDATE inisial SET user_id = ?, nama = ?, inisial = ?, is_active = ? WHERE id = ?");
    $stmt->bind_param("issii", $user_id, $nama, $inisial, $is_active, $id);
    if ($stmt->execute()) {
        header("Location: manage-inisial.php?success=Inisial berhasil diupdate");
    } else {
        header("Location: manage-inisial.php?error=Gagal mengupdate inisial");
    }
    exit();
}

// Delete inisial
if (isset($_GET['delete_inisial'])) {
    $id = (int)$_GET['delete_inisial'];
    $stmt = $conn->prepare("DELETE FROM inisial WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        header("Location: manage-inisial.php?success=Inisial berhasil dihapus");
    } else {
        header("Location: manage-inisial.php?error=Gagal menghapus inisial");
    }
    exit();
}

// Re-generate inisial from authorized_signers
if (isset($_GET['regenerate'])) {
    // Get all authorized signers
    $signers = $conn->query("SELECT user_id, nama FROM authorized_signers WHERE is_active = 1");
    $updated = 0;
    $inserted = 0;

    while ($signer = $signers->fetch_assoc()) {
        // Generate initials from name
        $words = preg_split('/\s+/', trim($signer['nama']));
        $initials = '';
        foreach ($words as $word) {
            if (!empty($word)) {
                $initials .= strtoupper(substr($word, 0, 1));
            }
        }

        // Check if exists
        $checkStmt = $conn->prepare("SELECT id FROM inisial WHERE user_id = ?");
        $checkStmt->bind_param("i", $signer['user_id']);
        $checkStmt->execute();
        $exists = $checkStmt->get_result()->fetch_assoc();

        if ($exists) {
            // Update
            $updateStmt = $conn->prepare("UPDATE inisial SET nama = ?, inisial = ? WHERE user_id = ?");
            $updateStmt->bind_param("ssi", $signer['nama'], $initials, $signer['user_id']);
            $updateStmt->execute();
            $updated++;
        } else {
            // Insert
            $insertStmt = $conn->prepare("INSERT INTO inisial (user_id, nama, inisial, is_active) VALUES (?, ?, ?, 1)");
            $insertStmt->bind_param("iss", $signer['user_id'], $signer['nama'], $initials);
            $insertStmt->execute();
            $inserted++;
        }
    }

    header("Location: manage-inisial.php?success=Regenerasi selesai. $inserted baru, $updated diupdate.");
    exit();
}

// Fetch data
$inisialData = $conn->query("
    SELECT i.*, u.username, u.jabatan as user_jabatan
    FROM inisial i
    LEFT JOIN users u ON i.user_id = u.id
    ORDER BY i.nama ASC
");

// Users list for dropdown
$usersList = $conn->query("SELECT id, nama, username, jabatan FROM users WHERE tipe IN ('user', 'admin', 'editor') ORDER BY nama ASC");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">
    <title>Manajemen Inisial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
    .sidebar {
        background-color: #0c50e1;
        color: white;
        min-height: 100vh;
        padding: 15px;
    }

    .sidebar a {
        color: white;
        text-decoration: none;
        display: block;
        padding: 10px;
        margin: 5px 0;
        border-radius: 5px;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background-color: #ffc107;
        color: #0047ab;
    }

    .table thead th {
        background-color: #0c50e1;
        color: #ffc107;
    }

    .sidebar-animated {
        background-color: #001eff;
        padding: 20px 10px;
        height: 100vh;
        width: 250px;
        max-height: 100vh;
        overflow-y: auto;
        scrollbar-width: thin;
    }

    .sidebar-animated a {
        color: #FFFFFFFF;
        text-decoration: none;
        font-size: 18px;
        display: flex;
        align-items: center;
        padding: 10px;
        border-radius: 5px;
        transition: background-color 0.3s ease, transform 0.3s ease;
    }

    .sidebar-animated a:hover {
        background-color: #ffc107;
        color: #fff;
        transform: translateX(5px);
    }

    .sidebar-animated a i {
        margin-right: 10px;
    }

    .sidebar-animated .submenu {
        padding-left: 1px;
        overflow: hidden;
    }

    .arrow-icon {
        margin-left: auto;
        transition: transform 0.3s;
    }

    .submenu a {
        font-size: 16px;
        color: #FFFFFFFF;
    }

    .submenu a:hover {
        color: #001eff;
        transform: translateX(5px);
    }

    .sidebar-animated a.active {
        background-color: #ffc107;
        color: #fff;
        font-weight: bold;
    }

    .inisial-badge {
        font-size: 1.2rem;
        font-weight: bold;
        padding: 8px 16px;
        border-radius: 8px;
        background: linear-gradient(135deg, #0c50e1, #001eff);
        color: #ffc107;
        display: inline-block;
        min-width: 60px;
        text-align: center;
    }

    .status-active {
        color: #28a745;
    }

    .status-inactive {
        color: #dc3545;
    }
    </style>
</head>

<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar sidebar-animated">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu"
                aria-expanded="true">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1"></i>
            </a>
            <div id="letterSubmenu" class="collapse show submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
                <a href="manajemen-surat.php"><i class="fas fa-cog"></i> Manajemen Data Surat</a>
                <a href="letter-order.php"><i class="fas fa-list-ol"></i> Urutan Surat</a>
                <a href="manage-inisial.php" class="active"><i class="fas fa-signature"></i> Manajemen Inisial</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse"
                data-bs-target="#todolistSubmenu">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1"></i>
            </a>
            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php"><i class="fas fa-clock"></i> List</a>
                <a href="record-agenda.php"><i class="fas fa-clipboard-list"></i> Record</a>
            </div>

            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>

            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer</a>
                <a href="header.php"><i class="fas fa-heading"></i> Header</a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home</a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar</a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil</a>
                <a href="trav.php"><i class="fas fa-font"></i> Travoy</a>
                <a href="jaringan.php"><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php"><i class="fas fa-comments"></i> Chatbot</a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>

            <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>

        <!-- Main Content -->
        <div class="container-fluid py-4">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-signature me-2"></i>Manajemen Inisial Paraf</h5>
                    <div>
                        <!-- <a href="?regenerate=1" class="btn btn-warning btn-sm me-2" onclick="return confirm('Regenerasi inisial dari authorized_signers?');">
                            <i class="fas fa-sync-alt"></i> Regenerasi
                        </a> -->
                        <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal"
                            data-bs-target="#addModal">
                            <i class="fas fa-plus"></i> Tambah Inisial
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <?php if ($success): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <?= htmlspecialchars($success) ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>
                    <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show">
                        <?= htmlspecialchars($error) ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        Inisial digunakan untuk paraf surat. Format: Huruf kapital dari huruf pertama tiap kata nama.
                        <br>Contoh: "Bambang Hermawan" → <strong>BH</strong>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead>
                                <tr class="text-center">
                                    <th style="width: 5%">No</th>
                                    <th style="width: 25%">Nama</th>
                                    <th style="width: 15%">Inisial</th>
                                    <th style="width: 20%">User Account</th>
                                    <th style="width: 10%">Status</th>
                                    <th style="width: 15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                while ($row = $inisialData->fetch_assoc()):
                                ?>
                                <tr>
                                    <td class="text-center"><?= $no++ ?></td>
                                    <td>
                                        <strong><?= htmlspecialchars($row['nama']) ?></strong>
                                        <?php if ($row['user_jabatan']): ?>
                                        <br><small
                                            class="text-muted"><?= htmlspecialchars($row['user_jabatan']) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="inisial-badge"><?= htmlspecialchars($row['inisial']) ?></span>
                                    </td>
                                    <td>
                                        <?php if ($row['username']): ?>
                                        <i class="fas fa-user text-primary"></i>
                                        <?= htmlspecialchars($row['username']) ?>
                                        <?php else: ?>
                                        <span class="text-muted">- Tidak terhubung -</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if ($row['is_active']): ?>
                                        <span class="badge bg-success"><i class="fas fa-check"></i> Aktif</span>
                                        <?php else: ?>
                                        <span class="badge bg-secondary"><i class="fas fa-times"></i> Nonaktif</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-sm btn-warning btn-edit"
                                            data-id="<?= $row['id'] ?>" data-user_id="<?= $row['user_id'] ?>"
                                            data-nama="<?= htmlspecialchars($row['nama']) ?>"
                                            data-inisial="<?= htmlspecialchars($row['inisial']) ?>"
                                            data-is_active="<?= $row['is_active'] ?>">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <a href="?delete_inisial=<?= $row['id'] ?>" class="btn btn-sm btn-danger"
                                            onclick="return confirm('Yakin ingin menghapus inisial ini?');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Modal -->
    <div class="modal fade" id="addModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title"><i class="fas fa-plus"></i> Tambah Inisial</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Hubungkan ke User (Opsional)</label>
                            <select name="user_id" class="form-select" id="addUserId">
                                <option value="">-- Pilih User --</option>
                                <?php
                                $usersList->data_seek(0);
                                while ($u = $usersList->fetch_assoc()):
                                ?>
                                <option value="<?= $u['id'] ?>" data-nama="<?= htmlspecialchars($u['nama']) ?>">
                                    <?= htmlspecialchars($u['nama']) ?> (<?= htmlspecialchars($u['username']) ?>)
                                </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="addNama" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Inisial <span class="text-danger">*</span></label>
                            <input type="text" name="inisial" id="addInisial" class="form-control"
                                style="font-weight: bold; font-size: 1.2rem;" maxlength="10" required>
                            <div class="form-text">Maks 10 karakter. Dapat huruf besar atau kecil.</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="tambah_inisial" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" name="id" id="editId">
                    <div class="modal-header bg-warning">
                        <h5 class="modal-title"><i class="fas fa-edit"></i> Edit Inisial</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Hubungkan ke User (Opsional)</label>
                            <select name="user_id" class="form-select" id="editUserId">
                                <option value="">-- Pilih User --</option>
                                <?php
                                $usersList->data_seek(0);
                                while ($u = $usersList->fetch_assoc()):
                                ?>
                                <option value="<?= $u['id'] ?>">
                                    <?= htmlspecialchars($u['nama']) ?> (<?= htmlspecialchars($u['username']) ?>)
                                </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="editNama" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Inisial <span class="text-danger">*</span></label>
                            <input type="text" name="inisial" id="editInisial" class="form-control"
                                style="font-weight: bold; font-size: 1.2rem;" maxlength="10" required>
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="is_active" id="editIsActive" class="form-check-input"
                                    value="1">
                                <label class="form-check-label" for="editIsActive">Aktif</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="edit_inisial" class="btn btn-warning">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-generate inisial when user is selected (Add modal)
        const addUserSelect = document.getElementById('addUserId');
        const addNamaInput = document.getElementById('addNama');
        const addInisialInput = document.getElementById('addInisial');

        addUserSelect.addEventListener('change', function() {
            const selected = this.options[this.selectedIndex];
            if (selected.value) {
                const nama = selected.dataset.nama;
                addNamaInput.value = nama;
                // Generate initials
                const words = nama.split(/\s+/);
                let initials = '';
                words.forEach(word => {
                    if (word.length > 0) initials += word.charAt(0).toUpperCase();
                });
                addInisialInput.value = initials;
            }
        });

        // Auto-generate inisial when nama changes
        addNamaInput.addEventListener('blur', function() {
            if (!addInisialInput.value) {
                const words = this.value.split(/\s+/);
                let initials = '';
                words.forEach(word => {
                    if (word.length > 0) initials += word.charAt(0).toUpperCase();
                });
                addInisialInput.value = initials;
            }
        });

        // Edit modal
        const editModal = new bootstrap.Modal(document.getElementById('editModal'));
        document.querySelectorAll('.btn-edit').forEach(btn => {
            btn.addEventListener('click', function() {
                document.getElementById('editId').value = this.dataset.id;
                document.getElementById('editUserId').value = this.dataset.user_id || '';
                document.getElementById('editNama').value = this.dataset.nama;
                document.getElementById('editInisial').value = this.dataset.inisial;
                document.getElementById('editIsActive').checked = this.dataset.is_active ===
                    '1';
                editModal.show();
            });
        });
    });
    </script>
</body>

</html>