<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');
include(__DIR__ . '/../includes/functions.php');

// Admin check
$username = $_SESSION['username'] ?? null;
if (!$username) {
    header('Location: ../login.php');
    exit();
}
$stmt = $conn->prepare("SELECT id, tipe, nama FROM users WHERE username = ? LIMIT 1");
$stmt->bind_param('s', $username);
$stmt->execute();
$res = $stmt->get_result();
$user = $res ? $res->fetch_assoc() : null;
$stmt->close();
if (!$user || strtolower(trim($user['tipe'])) !== 'admin') {
    header('Location: ../login.php');
    exit();
}

// compute agenda active badge to avoid undefined variable in sidebar
date_default_timezone_set("Asia/Jakarta");
$today = date('Y-m-d');
$nowTime = date('H:i');
$jumlahAgendaAktif = 0;
if ($s = $conn->prepare("SELECT COUNT(*) FROM agenda WHERE tanggal > ? OR (tanggal = ? AND waktu >= ?)")) {
    $s->bind_param("sss", $today, $today, $nowTime);
    $s->execute();
    $s->bind_result($jumlah);
    if ($s->fetch()) $jumlahAgendaAktif = (int)$jumlah;
    $s->close();
}

// Build full mapping across all letter_order rows for chain computation
list($map, $nameMap) = buildSupervisorMap($conn);

// Preconfigured list of 16 users to display in this admin page
$preconfiguredNames = [
    'Netty Renova',
    'Indarani',
    'Andri Supriadi',
    'Muhammad Reza Pahlevi Guntur',
    'Bambang Hermawan',
    'Fakirno',
    'Ragil Suparmadi',
    'Auzi Trisiyas Sulkha',
    'Muhammad Tachyuddin',
    'Kukuh Prasojo',
    'Rendy Hendra Prasetya',
    'Tedy Agus Harianto',
    'Budhi Satria Permana',
    'M.Nafi Uddin',
    'Harbetta Yurisa Tanydag',
    'Abdul Rokhman'
];

$escaped = array_map(function ($n) use ($conn) {
    return "'" . $conn->real_escape_string($n) . "'";
}, $preconfiguredNames);
$fieldOrder = implode(',', array_map(function ($n) {
    return "'" . addslashes($n) . "'";
}, $preconfiguredNames));
// show the 16 preconfigured users plus any user who already has a mapping (lo.id is not null)
$sql = "SELECT u.id as user_id, u.nama as user_name, s.nama AS supervisor_name, lo.id as lo_id, COUNT(o.id) AS jumlah_letters
     FROM users u
     LEFT JOIN letter_order lo ON lo.user_id = u.id
     LEFT JOIN users s ON lo.supervisor_id = s.id
     LEFT JOIN office o ON o.dibuat_oleh = u.id
     WHERE (u.nama IN (" . implode(',', $escaped) . ") OR lo.id IS NOT NULL)
     GROUP BY u.id
     ORDER BY (FIELD(u.nama, $fieldOrder) = 0), FIELD(u.nama, $fieldOrder), u.nama";
$rows = [];
if ($r = $conn->query($sql)) {
    $rows = $r->fetch_all(MYSQLI_ASSOC);
    $r->free();
}

// We'll use the buildSupervisorMap() mapping above and helper getApprovalChainFromMaps() from letter-order-functions.php

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Urutan Surat - Admin</title>
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        /* Copied site styles from record-letter for consistent layout */
        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        .table thead {
            background-color: #0047ab;
            color: #fff;
            text-transform: uppercase;
            font-weight: bold;
        }

        .table thead th {
            background-color: #0c50e1;
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            overflow-y: auto;
            overflow-x: hidden;
            padding-bottom: 20px;
            margin-bottom: 0;
            scrollbar-width: thin;
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
                <a href="manajemen-surat.php"><i class="fas fa-folder-open"></i> Manajemen Data Surat</a>
                <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
                <a href="manage-inisial.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'manage-inisial.php') ? 'active' : ''; ?>"><i class="fas fa-signature"></i> Manajemen Inisial</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu">
                <i class="fas fa-images" class="active"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <div id="mainContent" class="container-fluid py-3">
            <?php if (!empty($_GET['created'])): ?>
                <div class="alert alert-success">Pemetaan urutan surat berhasil dibuat.</div>
            <?php endif; ?>
            <?php if (!empty($_GET['updated'])): ?>
                <div class="alert alert-success">Pemetaan urutan surat berhasil diperbarui.</div>
            <?php endif; ?>
            <?php if (!empty($_GET['deleted'])): ?>
                <div class="alert alert-success">Pemetaan urutan surat berhasil dihapus.</div>
            <?php endif; ?>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h2>Urutan Surat</h2>
                <div>
                    <a href="add-letter-order.php" class="btn btn-success me-2">Tambah</a>
                    <a href="record-letter.php" class="btn btn-outline-secondary">Kembali</a>
                </div>
            </div>

            <div class="card">
                <div class="card-body p-2">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover table-bordered mb-0">
                            <thead class="table-primary">
                                <tr>
                                    <th style="width:8%">ID</th>
                                    <th>Nama Pengguna</th>
                                    <th>Urutan Jabatan</th>
                                    <th style="width:24%">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($rows)): ?>
                                    <tr>
                                        <td colspan="4" class="text-center">Tidak ada data</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($rows as $r): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($r['lo_id'] ?? $r['user_id']) ?></td>
                                            <td><?= htmlspecialchars($r['user_name'] ?? '(unknown)') ?> <?php if (!in_array($r['user_name'], $preconfiguredNames)) echo '<span class="badge bg-secondary">Custom</span>'; ?></td>
                                            <td><small><?= htmlspecialchars(getApprovalChainFromMaps((int)$r['user_id'], $nameMap, $map) ?: 'Jabatan Tertinggi') ?></small></td>
                                            <!-- Approver chain column removed -->
                                            <td class="text-center">
                                                <?php if (!empty($r['lo_id'])): ?>
                                                    <a href="edit-letter-order.php?id=<?= (int)$r['lo_id'] ?>" class="btn btn-sm btn-primary">Edit</a>
                                                    <button type="button" class="btn btn-sm btn-danger ms-1 btn-delete" data-id="<?= (int)$r['lo_id'] ?>" data-name="<?= htmlspecialchars($r['user_name'] ?? '') ?>">Hapus</button>
                                                <?php else: ?>
                                                    <a href="add-letter-order.php?user_id=<?= (int)$r['user_id'] ?>" class="btn btn-sm btn-success">Add</a>
                                                <?php endif; ?>
                                                <!-- Manage Chain button removed per admin consolidation; use Edit or Add mapping to manage approvers -->
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="confirmDeleteModal" tabindex="-1" aria-labelledby="confirmDeleteLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="confirmDeleteLabel">Konfirmasi Hapus</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p id="confirmDeleteText">Apakah Anda yakin ingin menghapus pemetaan urutan surat ini dan dokumen terkait?</p>
                        </div>
                        <div class="modal-footer">
                            <form id="deleteForm" method="POST" action="delete-letter-order.php">
                                <input type="hidden" name="id" id="deleteLoId" value="">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-danger">Hapus</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const bsModal = new bootstrap.Modal(document.getElementById('confirmDeleteModal'));
                    document.querySelectorAll('.btn-delete').forEach(function(btn) {
                        btn.addEventListener('click', function() {
                            const id = this.getAttribute('data-id');
                            const name = this.getAttribute('data-name');
                            document.getElementById('deleteLoId').value = id;
                            document.getElementById('confirmDeleteText').textContent = 'Hapus pemetaan urutan surat untuk ' + (name || 'pengguna ini') + '? Ini akan menghapus dokumen yang dibuat oleh pengguna ini.';
                            bsModal.show();
                        });
                    });
                });
            </script>
        </div>
</body>

</html>