<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

$username = $_SESSION['username'];
$query = "SELECT tipe FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}






date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;




function getSearchData($conn, $table, $fields, $limit, $page, $search, $order = 'id ASC')
{
    $offset = ($page - 1) * $limit;
    $whereClause = '';
    if (!empty($search)) {
        $likeClauses = [];
        foreach ($fields as $field) {
            $likeClauses[] = "$field LIKE '%" . $conn->real_escape_string($search) . "%'";
        }
        $whereClause = 'WHERE ' . implode(' OR ', $likeClauses);
    }

    $total = $conn->query("SELECT COUNT(*) FROM $table $whereClause")->fetch_row()[0];
    $sql = "SELECT * FROM $table $whereClause ORDER BY $order LIMIT $offset, $limit";
    $data = $conn->query($sql);
    $totalPages = ceil($total / $limit);
    return ['data' => $data, 'totalPages' => $totalPages, 'totalRows' => $total];
}

function renderPagination($key, $totalPages, $page, $limit, $search)
{
    if ($totalPages <= 1) return;
    echo '<nav aria-label="Page navigation"><ul class="pagination justify-content-center mt-3">';
    echo '<li class="page-item ' . ($page <= 1 ? 'disabled' : '') . '">';
    echo '<a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . max(1, $page - 1) . '">Prev</a></li>';
    for ($i = 1; $i <= $totalPages; $i++) {
        $active = ($page == $i) ? 'active' : '';
        echo '<li class="page-item ' . $active . '"><a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . $i . '">' . $i . '</a></li>';
    }
    echo '<li class="page-item ' . ($page >= $totalPages ? 'disabled' : '') . '">';
    echo '<a class="page-link" href="?limit_' . $key . '=' . $limit . '&search_' . $key . '=' . urlencode($search) . '&page_' . $key . '=' . min($totalPages, $page + 1) . '">Next</a></li>';
    echo '</ul></nav>';
}

$profil_limit = isset($_GET['limit_profil']) ? ($_GET['limit_profil'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_profil']) : 5;
$profil_page = isset($_GET['page_profil']) ? (int)$_GET['page_profil'] : 1;
$search_profil = isset($_GET['search_profil']) ? $_GET['search_profil'] : '';

$misi_limit = isset($_GET['limit_misi']) ? ($_GET['limit_misi'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_misi']) : 5;
$misi_page = isset($_GET['page_misi']) ? (int)$_GET['page_misi'] : 1;
$search_misi = isset($_GET['search_misi']) ? $_GET['search_misi'] : '';

$nilai_limit = isset($_GET['limit_nilai']) ? ($_GET['limit_nilai'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_nilai']) : 5;
$nilai_page = isset($_GET['page_nilai']) ? (int)$_GET['page_nilai'] : 1;
$search_nilai = isset($_GET['search_nilai']) ? $_GET['search_nilai'] : '';

$jejak_limit = isset($_GET['limit_jejak']) ? ($_GET['limit_jejak'] === 'All' ? PHP_INT_MAX : (int)$_GET['limit_jejak']) : 5;
$jejak_page = isset($_GET['page_jejak']) ? (int)$_GET['page_jejak'] : 1;
$search_jejak = isset($_GET['search_jejak']) ? $_GET['search_jejak'] : '';




$profil = getSearchData($conn, 'gratifikasi', [
    'judul_satu',
    'sub_judul_satu',
    'konsultasi',
    'isi_konsultasi_satu',
    'email',
    'isi_konsultasi_dua',
    'gambar',
    'judul_dua',
    'sub_judul_dua',
    'deskripsi',
    'pelaporan',
    'dokumen',
    'deskripsi_dokumen'
], $profil_limit, $profil_page, $search_profil, 'created_at DESC');

$misi = getSearchData($conn, 'gratifikasi_ikon', ['ikon', 'deskripsi_ikon'], $misi_limit, $misi_page, $search_misi, 'id ASC');

$nilai = getSearchData($conn, 'pelaporan', ['isi_pelaporan'], $nilai_limit, $nilai_page, $search_nilai, 'created_at ASC');

$jejak = getSearchData($conn, 'dokumen', ['isi_dokumen'], $jejak_limit, $jejak_page, $search_jejak, 'created_at ASC');

?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">

    <title>Gratifikasi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 8px 12px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 250px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 6px 20px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }
    </style>
</head>

<body>
    <div class="d-flex">

        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu" aria-expanded="false">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="manajemen-surat.php"><i class="fas fa-folder-open"></i> Manajemen Data Surat</a>
            <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu" aria-expanded="false">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php" class="active"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>
            <a href="#locSubmenu" class="submenu-toggle " data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>Data Gratifikasi</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit_profil" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ([5, 20, 'All'] as $opt): ?>
                                <option value="<?= $opt ?>" <?= $profil_limit == ($opt === 'All' ? PHP_INT_MAX : $opt) ? 'selected' : '' ?>><?= $opt ?></option>
                            <?php endforeach; ?>
                        </select>
                        <input type="hidden" name="search_profil" value="<?= htmlspecialchars($search_profil) ?>">
                        <input type="hidden" name="page_profil" value="1">
                    </form>

                    <form method="get" class="search-box-new d-flex align-items-center">
                        <input type="text" id="searchInputNew" name="search_profil" class="search-input-new form-control form-control-sm me-1" placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($search_profil) ?>">
                        <input type="hidden" name="profil_limit" value="<?= $profil_limit ?>">
                        <button type="submit" id="searchButtonNew" class="search-btn-new btn btn-primary btn-sm"><i class="fas fa-search"></i> Cari</button>
                    </form>
                </div>
                <div>
                    <a href="add/add_gratifikasi.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Tambah Gratifikasi</a>
                </div>
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>ID</th>
                        <th>Judul Satu</th>
                        <th>Sub Judul Satu</th>
                        <th>Konsultasi</th>
                        <th>Isi Konsultasi 1</th>
                        <th>Email</th>
                        <th>Isi Konsultasi 2</th>
                        <th>Gambar</th>
                        <th>Judul Dua</th>
                        <th>Sub Judul Dua</th>
                        <th>Deskripsi</th>
                        <th>Pelaporan</th>
                        <th>Dokumen</th>
                        <th>Deskripsi Dokumen</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $profil['data']->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['judul_satu']) ?></td>
                            <td><?= htmlspecialchars($row['sub_judul_satu']) ?></td>
                            <td><?= htmlspecialchars($row['konsultasi']) ?></td>
                            <td><?= htmlspecialchars($row['isi_konsultasi_satu']) ?></td>
                            <td><?= htmlspecialchars($row['email']) ?></td>
                            <td><?= htmlspecialchars($row['isi_konsultasi_dua']) ?></td>
                            <td><img src="img/baru1/<?= $row['gambar'] ?>" width="100"></td>
                            <td><?= htmlspecialchars($row['judul_dua']) ?></td>
                            <td><?= htmlspecialchars($row['sub_judul_dua']) ?></td>
                            <td><?= htmlspecialchars($row['deskripsi']) ?></td>
                            <td><?= htmlspecialchars($row['pelaporan']) ?></td>
                            <td><?= htmlspecialchars($row['dokumen']) ?></td>
                            <td><?= htmlspecialchars($row['deskripsi_dokumen']) ?></td>
                            <td><?= $row['created_at'] ?></td>
                            <td>
                                <a href="edit/edit_gratifikasi.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                <a href="delete/delete_gratifikasi.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus?')"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
            <?php renderPagination('profil', $profil['totalPages'], $profil_page, $profil_limit, $search_profil); ?>

            <hr>

            <h2>Data Ikon Gratifikasi</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit_misi" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ([5, 20, 'All'] as $opt): ?>
                                <option value="<?= $opt ?>" <?= $misi_limit == ($opt === 'All' ? PHP_INT_MAX : $opt) ? 'selected' : '' ?>><?= $opt ?></option>
                            <?php endforeach; ?>
                        </select>
                        <input type="hidden" name="search_misi" value="<?= htmlspecialchars($search_misi) ?>">
                        <input type="hidden" name="page_misi" value="1">
                    </form>

                    <form method="get" class="search-box-new d-flex align-items-center">
                        <input type="text" id="searchInputNew1" name="search_misi" class="search-input-new form-control form-control-sm me-1" placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($search_misi) ?>">
                        <input type="hidden" name="misi_limit" value="<?= $misi_limit ?>">
                        <button type="submit" id="searchButtonNew1" class="search-btn-new btn btn-primary btn-sm"><i class="fas fa-search"></i> Cari</button>
                    </form>
                </div>
                <div>
                    <a href="add/add_ikongratifikasi.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Tambah Ikon Gratifikasi</a>
                </div>
            </div>


            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>ID</th>
                        <th>Ikon</th>
                        <th>Deskripsi Ikon</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $misi['data']->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['ikon']) ?></td>
                            <td><?= htmlspecialchars($row['deskripsi_ikon']) ?></td>
                            <td><?= $row['created_at'] ?></td>
                            <td>
                                <a href="edit/edit_ikongratifikasi.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                <a href="delete/delete_ikongratifikasi.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus?')"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
            <?php renderPagination('misi', $misi['totalPages'], $misi_page, $misi_limit, $search_misi); ?>

            <hr>

            <h2>Data Pelaporan</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit_nilai" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ([5, 20, 'All'] as $opt): ?>
                                <option value="<?= $opt ?>" <?= $nilai_limit == ($opt === 'All' ? PHP_INT_MAX : $opt) ? 'selected' : '' ?>><?= $opt ?></option>
                            <?php endforeach; ?>
                        </select>
                        <input type="hidden" name="search_nilai" value="<?= htmlspecialchars($search_nilai) ?>">
                        <input type="hidden" name="page_nilai" value="1">
                    </form>

                    <form method="get" class="search-box-new d-flex align-items-center">
                        <input type="text" id="searchInputNew2" name="search_nilai" class="search-input-new form-control form-control-sm me-1" placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($search_nilai) ?>">
                        <input type="hidden" name="nilai_limit" value="<?= $nilai_limit ?>">
                        <button type="submit" id="searchButtonNew2" class="search-btn-new btn btn-primary btn-sm"><i class="fas fa-search"></i> Cari</button>
                    </form>
                </div>
                <div>
                    <a href="add/add_pelaporan.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Tambah Pelaporan</a>
                </div>
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>ID</th>
                        <th>Isi Pelaporan</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $nilai['data']->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['isi_pelaporan']) ?></td>
                            <td><?= $row['created_at'] ?></td>
                            <td>
                                <a href="edit/edit_pelaporan.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                <a href="delete/delete_pelaporan.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus?')"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
            <?php renderPagination('nilai', $nilai['totalPages'], $nilai_page, $nilai_limit, $search_nilai); ?>

            <hr>

            <h2>Data Dokumen</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit_jejak" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ([5, 20, 'All'] as $opt): ?>
                                <option value="<?= $opt ?>" <?= $jejak_limit == ($opt === 'All' ? PHP_INT_MAX : $opt) ? 'selected' : '' ?>><?= $opt ?></option>
                            <?php endforeach; ?>
                        </select>
                        <input type="hidden" name="search_jejak" value="<?= htmlspecialchars($search_jejak) ?>">
                        <input type="hidden" name="page_jejak" value="1">
                    </form>

                    <form method="get" class="search-box-new d-flex align-items-center">
                        <input type="text" id="searchInputNew3" name="search_jejak" class="search-input-new form-control form-control-sm me-1" placeholder="Tap untuk mencari..."
                            value="<?= htmlspecialchars($search_jejak) ?>">
                        <input type="hidden" name="jejak_limit" value="<?= $jejak_limit ?>">
                        <button type="submit" id="searchButtonNew3" class="search-btn-new btn btn-primary btn-sm"><i class="fas fa-search"></i> Cari</button>
                    </form>
                </div>
                <div>
                    <a href="add/add_dokumen.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Tambah Dokumen</a>
                </div>
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>ID</th>
                        <th>Isi Dokumen</th>
                        <th>Dibuat</th>
                        <th>Tombol</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $jejak['data']->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['isi_dokumen']) ?></td>
                            <td><?= $row['created_at'] ?></td>
                            <td>
                                <a href="edit/edit_dokumen.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                                <a href="delete/delete_dokumen.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus?')"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
            <?php renderPagination('jejak', $jejak['totalPages'], $jejak_page, $jejak_limit, $search_jejak); ?>

        </div>
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
        <script>
            const searchInputNew = document.getElementById('searchInputNew');
            const searchButtonNew = document.getElementById('searchButtonNew');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew.addEventListener('focus', function() {
                searchButtonNew.classList.add('show'); // Tampilkan tombol
                searchInputNew.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew.addEventListener('blur', function() {
                if (!searchInputNew.value.trim()) {
                    searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew1 = document.getElementById('searchInputNew1');
            const searchButtonNew1 = document.getElementById('searchButtonNew1');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew1.addEventListener('focus', function() {
                searchButtonNew1.classList.add('show'); // Tampilkan tombol
                searchInputNew1.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew1.addEventListener('blur', function() {
                if (!searchInputNew1.value.trim()) {
                    searchButtonNew1.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew1.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew2 = document.getElementById('searchInputNew2');
            const searchButtonNew2 = document.getElementById('searchButtonNew2');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew2.addEventListener('focus', function() {
                searchButtonNew2.classList.add('show'); // Tampilkan tombol
                searchInputNew2.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew2.addEventListener('blur', function() {
                if (!searchInputNew2.value.trim()) {
                    searchButtonNew2.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew2.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });


            const searchInputNew3 = document.getElementById('searchInputNew3');
            const searchButtonNew3 = document.getElementById('searchButtonNew3');

            // Event listener untuk memperlihatkan tombol ketika input diklik
            searchInputNew3.addEventListener('focus', function() {
                searchButtonNew3.classList.add('show'); // Tampilkan tombol
                searchInputNew3.placeholder = ''; // Hilangkan placeholder
            });

            // Event listener untuk menyembunyikan tombol ketika input kosong
            searchInputNew3.addEventListener('blur', function() {
                if (!searchInputNew3.value.trim()) {
                    searchButtonNew3.classList.remove('show'); // Sembunyikan tombol
                    searchInputNew3.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                }
            });
        </script>
</body>

</html>