<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

// Cek apakah tipe user adalah admin
$username = $_SESSION['username'];
$query = "SELECT tipe FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'admin') {
    // Redirect jika bukan admin
    header('Location: ../login.php');
    exit();
}


date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;






$urutanBulan = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];

// Ambil data untuk dropdown filter
$pegawaiOptions = $conn->query("SELECT DISTINCT users.id, users.nama FROM users INNER JOIN gaji ON gaji.user_id = users.id ORDER BY users.nama ASC");
$tahunOptions = $conn->query("SELECT DISTINCT tahun FROM gaji ORDER BY tahun DESC");
$bulanOptions = $conn->query("SELECT DISTINCT bulan FROM gaji");
$tipeOptions = $conn->query("SELECT DISTINCT tipe FROM gaji");

// Ambil filter dari URL
$filter_pegawai = $_GET['filter_pegawai'] ?? '';
$filter_tahun = $_GET['filter_tahun'] ?? '';
$filter_bulan = $_GET['filter_bulan'] ?? '';
$filter_tipe = $_GET['filter_tipe'] ?? '';




// Fungsi untuk mengambil data dari tabel gaji (join users)
function fetchGaji($conn)
{
    $sql = "SELECT gaji.*, users.nama 
            FROM gaji 
            INNER JOIN users ON gaji.user_id = users.id 
            ORDER BY gaji.created_at DESC";
    return $conn->query($sql);
}

// Ambil data dari tabel gaji
$gaji = fetchGaji($conn);


require_once __DIR__ . '/vendor/autoload.php';


use PhpOffice\PhpSpreadsheet\IOFactory;


// Tangani form submit (simpan data gaji)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tambah_gaji'])) {
    $user_id = $_POST['user_id'];
    $tahun = $_POST['tahun'];
    $bulan = $_POST['bulan'];
    $tipe = $_POST['tipe'];
    $slip_link = $_POST['slip_link'];

    $stmt = $conn->prepare("INSERT INTO gaji (user_id, tahun, bulan, tipe, slip_link) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("issss", $user_id, $tahun, $bulan, $tipe, $slip_link);
    $stmt->execute();

    // Redirect agar tidak re-submit saat refresh
    header("Location: gaji.php");
    exit();
}
// Tangani form edit
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_gaji'])) {
    $gaji_id = $_POST['gaji_id'];
    $tahun = $_POST['tahun'];
    $bulan = $_POST['bulan'];
    $tipe = $_POST['tipe'];
    $slip_link = $_POST['slip_link'];

    $user_id = $_POST['user_id'];
    $stmt = $conn->prepare("UPDATE gaji SET user_id = ?, tahun = ?, bulan = ?, tipe = ?, slip_link = ? WHERE id = ?");
    $stmt->bind_param("iisssi", $user_id, $tahun, $bulan, $tipe, $slip_link, $gaji_id);
    $stmt->execute();

    header("Location: gaji.php");
    exit();
}


// Tangani hapus gaji
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['hapus_gaji'])) {
    $gaji_id = $_POST['gaji_id'];
    $stmt = $conn->prepare("DELETE FROM gaji WHERE id = ?");
    $stmt->bind_param("i", $gaji_id);
    $stmt->execute();

    header("Location: gaji.php");
    exit();
}

// Import
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['import_gaji'])) {
    if (isset($_FILES['file_excel']['tmp_name'])) {
        $filePath = $_FILES['file_excel']['tmp_name'];

        try {
            $spreadsheet = IOFactory::load($filePath);
            $worksheet = $spreadsheet->getActiveSheet();

            foreach ($worksheet->getRowIterator() as $index => $row) {
                // Lewati baris pertama (header)
                if ($index === 1) continue;

                $cellIterator = $row->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false);

                $data = [];
                foreach ($cellIterator as $cell) {
                    $data[] = trim($cell->getValue());
                }

                // Validasi: lewati baris kosong, kolom tidak lengkap, atau baris keterangan
                if (
                    count($data) < 5 ||
                    empty($data[0]) || !is_numeric($data[0]) ||
                    strtolower($data[0]) === 'keterangan'
                ) {
                    continue;
                }

                // Simpan ke database
                $stmt = $conn->prepare("INSERT INTO gaji (user_id, tahun, bulan, tipe, slip_link) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("issss", $data[0], $data[1], $data[2], $data[3], $data[4]);
                $stmt->execute();
            }

            // Redirect kembali setelah selesai
            header("Location: gaji.php");
            exit();
        } catch (Exception $e) {
            echo "<script>alert('Gagal mengimpor data: " . $e->getMessage() . "');</script>";
        }
    }
}






$limitOptions = [20, 100, 'All'];
$selectedLimit = isset($_GET['limit']) ? $_GET['limit'] : 20;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;

// Hitung total data gaji
$search = $_GET['search'] ?? '';
// Ambil parameter sorting
$sort_by = $_GET['sort_by'] ?? 'created_at';
$sort_order = $_GET['sort_order'] ?? 'DESC';

$allowedSort = [
    'nama' => 'users.nama',
    'tahun' => 'gaji.tahun',
    // Ini trik untuk urut bulan sesuai kalender
    'bulan' => "FIELD(gaji.bulan, 'Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember')",
    'tipe' => 'gaji.tipe',
    'created_at' => 'gaji.created_at'
];

$sort_column = $allowedSort[$sort_by] ?? 'gaji.created_at';
$next_order = ($sort_order === 'ASC') ? 'DESC' : 'ASC';



function sortableHeader($label, $key, $currentSortBy, $currentOrder, $get)
{
    $nextOrder = ($currentSortBy === $key && $currentOrder === 'ASC') ? 'DESC' : 'ASC';

    if ($currentSortBy === $key) {
        $icon = $currentOrder === 'ASC'
            ? '<i class="fas fa-arrow-up ms-1"></i>'
            : '<i class="fas fa-arrow-down ms-1"></i>';
    } else {
        $icon = '<i class="fas fa-sort ms-1"></i>';
    }

    $params = array_merge($get, ['sort_by' => $key, 'sort_order' => $nextOrder]);
    $link = '?' . http_build_query($params);

    return "<a href=\"$link\" class=\"text-warning text-decoration-none\">$label $icon</a>";
}




$filterSqlParts = [];
if (!empty($search)) {
    $searchEsc = $conn->real_escape_string($search);
    $filterSqlParts[] = "(users.nama LIKE '%$searchEsc%' OR gaji.tahun LIKE '%$searchEsc%' OR gaji.bulan LIKE '%$searchEsc%' OR gaji.tipe LIKE '%$searchEsc%')";
}
if (!empty($filter_pegawai)) $filterSqlParts[] = "gaji.user_id = " . intval($filter_pegawai);
if (!empty($filter_tahun))   $filterSqlParts[] = "gaji.tahun = '" . $conn->real_escape_string($filter_tahun) . "'";
if (!empty($filter_bulan))   $filterSqlParts[] = "gaji.bulan = '" . $conn->real_escape_string($filter_bulan) . "'";
if (!empty($filter_tipe))    $filterSqlParts[] = "gaji.tipe = '" . $conn->real_escape_string($filter_tipe) . "'";

$searchSql = '';
if (!empty($filterSqlParts)) {
    $searchSql = 'WHERE ' . implode(' AND ', $filterSqlParts);
}


// Hitung total data hasil pencarian
$countSql = "SELECT COUNT(*) AS total 
             FROM gaji 
             INNER JOIN users ON gaji.user_id = users.id 
             $searchSql";
$countResult = $conn->query($countSql);
$totalData = $countResult->fetch_assoc()['total'];




$totalPages = $selectedLimit === 'All' ? 1 : ceil($totalData / $selectedLimit);
$offset = ($page - 1) * ($selectedLimit === 'All' ? $totalData : $selectedLimit);

// Ambil data paginasi gaji
$sql = "SELECT gaji.*, users.nama 
        FROM gaji 
        INNER JOIN users ON gaji.user_id = users.id 
        $searchSql
        ORDER BY $sort_column $sort_order " .
    ($selectedLimit === 'All' ? "" : "LIMIT $offset, $selectedLimit");

$gaji = $conn->query($sql);




?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="/jasa_marga/img/baru/logojp.png" rel="icon">

    <title>Gaji Pegawai</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        .pagination .page-link {
            color: #007bff;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }

        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 7px 9px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 165px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 174px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 7px 13px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }

        .custom-filter {
            border-radius: 15px;
            width: 151px;
            background-color: #001eff;
            color: #ffc107;
            border: 1px solid #ced4da;
            font-weight: 500;
            margin-right: 0px;
            transition: background-color 0.3s ease;
        }

        .custom-filter:focus {
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            outline: none;
            color: #001eff;
        }

        .custom-filter option {
            color: #001eff;
            background-color: #fff;
        }
    </style>
</head>

<body>
    <div class="d-flex">

        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php" class="active"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu" aria-expanded="false">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
                <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu" aria-expanded="false">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu" aria-expanded="false">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu" aria-expanded="false">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu" aria-expanded="false">
                <i class="fas fa-images"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>

            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <h2>Data Gaji Pegawai</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-1">
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ($limitOptions as $option): ?>
                                <option value="<?= $option ?>" <?= $selectedLimit == $option ? 'selected' : '' ?>>
                                    <?= $option ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </form>

                    <div class="search-container-new">
                        <form method="GET" action="" class="search-box-new me-0">
                            <input
                                type="text"
                                id="searchInputNew"
                                name="search"
                                class="search-input-new me-1"
                                placeholder="Tap untuk mencari..."
                                value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
                            <button type="submit" id="searchButtonNew" class="search-btn-new">
                                <i class="fas fa-search"></i> Cari
                            </button>
                        </form>
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-0">
                        <select name="filter_pegawai" class="form-select form-select-sm me-0 custom-filter" onchange="this.form.submit()">
                            <option value="">Semua Pegawai</option>
                            <?php while ($row = $pegawaiOptions->fetch_assoc()): ?>
                                <option value="<?= $row['id'] ?>" <?= $filter_pegawai == $row['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($row['nama']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>

                        <select name="filter_tahun" class="form-select form-select-sm me-0 custom-filter" onchange="this.form.submit()">
                            <option value="">Semua Tahun</option>
                            <?php while ($row = $tahunOptions->fetch_assoc()): ?>
                                <option value="<?= $row['tahun'] ?>" <?= $filter_tahun == $row['tahun'] ? 'selected' : '' ?>>
                                    <?= $row['tahun'] ?>
                                </option>
                            <?php endwhile; ?>
                        </select>

                        <select name="filter_bulan" class="form-select form-select-sm me-0 custom-filter" onchange="this.form.submit()">
                            <option value="">Semua Bulan</option>
                            <?php foreach ($urutanBulan as $bln): ?>
                                <option value="<?= $bln ?>" <?= $filter_bulan == $bln ? 'selected' : '' ?>><?= $bln ?></option>
                            <?php endforeach; ?>
                        </select>


                        <select name="filter_tipe" class="form-select form-select-sm me-1 custom-filter" onchange="this.form.submit()">
                            <option value="">Semua Tipe</option>
                            <?php while ($row = $tipeOptions->fetch_assoc()): ?>
                                <option value="<?= $row['tipe'] ?>" <?= $filter_tipe == $row['tipe'] ? 'selected' : '' ?>>
                                    <?= $row['tipe'] ?>
                                </option>
                            <?php endwhile; ?>
                        </select>

                        <!-- Hidden input untuk tetap bawa data limit, search, sort -->
                        <input type="hidden" name="limit" value="<?= htmlspecialchars($selectedLimit) ?>">
                        <input type="hidden" name="search" value="<?= htmlspecialchars($search) ?>">
                        <input type="hidden" name="sort_by" value="<?= htmlspecialchars($sort_by) ?>">
                        <input type="hidden" name="sort_order" value="<?= htmlspecialchars($sort_order) ?>">
                    </form>

                    <div>
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalTambahGaji">
                            <i class="fas fa-plus-circle"></i> Tambah Gaji
                        </button>
                        <button type="button" class="btn btn-dark text-white" data-bs-toggle="modal" data-bs-target="#modalImportGaji">
                            <i class="fas fa-file-import"></i> Import
                        </button>

                    </div>
                </div>

            </div>


            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th>No</th>
                        <th><?= sortableHeader('Nama Pegawai', 'nama', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Tahun', 'tahun', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Bulan', 'bulan', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Tipe', 'tipe', $sort_by, $sort_order, $_GET) ?></th>
                        <th>Slip Gaji</th>
                        <th><?= sortableHeader('Dibuat', 'created_at', $sort_by, $sort_order, $_GET) ?></th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = ($page - 1) * ($selectedLimit === 'All' ? $totalData : $selectedLimit) + 1;
                    while ($row = $gaji->fetch_assoc()): ?>
                        <tr>
                            <td class="text-center"><?php echo $no++; ?></td>
                            <td><?php echo htmlspecialchars($row['nama']); ?></td>
                            <td class="text-center"><?php echo $row['tahun']; ?></td>
                            <td class="text-center"><?php echo $row['bulan']; ?></td>
                            <td class="text-center"><?php echo $row['tipe']; ?></td>
                            <td class="text-center">
                                <?php if (!empty($row['slip_link'])): ?>
                                    <a href="<?php echo htmlspecialchars($row['slip_link']); ?>" target="_blank" class="btn btn-sm btn-primary">Lihat Slip</a>
                                <?php else: ?>
                                    <span class="text-muted">Belum tersedia</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center"><?php echo $row['created_at']; ?></td>
                            <td class="text-center">
                                <button type="button" class="btn btn-warning btn-sm mb-1" data-bs-toggle="modal" data-bs-target="#modalEditGaji<?php echo $row['id']; ?>">
                                    <i class="fas fa-edit"></i>
                                </button>

                                <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#modalDeleteGaji<?php echo $row['id']; ?>">
                                    <i class="fas fa-trash"></i>
                                </button>

                            </td>
                        </tr>
                        <!-- Modal Edit Gaji -->
                        <div class="modal fade" id="modalEditGaji<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="modalEditLabel<?php echo $row['id']; ?>" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <form method="POST" action="">
                                    <input type="hidden" name="edit_gaji" value="1">
                                    <input type="hidden" name="gaji_id" value="<?php echo $row['id']; ?>">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="modalEditLabel<?php echo $row['id']; ?>">Edit Gaji - <?php echo htmlspecialchars($row['nama']); ?></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                                        </div>
                                        <div class="modal-body">

                                            <div class="mb-3">
                                                <label for="user_id" class="form-label">Nama Pegawai</label>
                                                <select class="form-select" name="user_id" required>
                                                    <option value="" disabled>-- Pilih Pegawai --</option>
                                                    <?php
                                                    $pegawaiList = $conn->query("SELECT id, nama FROM users WHERE tipe = 'user'");
                                                    while ($pegawai = $pegawaiList->fetch_assoc()) {
                                                        $selected = ($pegawai['id'] == $row['user_id']) ? 'selected' : '';
                                                        echo '<option value="' . $pegawai['id'] . '" ' . $selected . '>' . htmlspecialchars($pegawai['nama']) . '</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="mb-3">
                                                <label for="tahun" class="form-label">Tahun</label>
                                                <input type="number" class="form-control" name="tahun" value="<?php echo $row['tahun']; ?>" required>
                                            </div>

                                            <div class="mb-3">
                                                <label for="bulan" class="form-label">Bulan</label>
                                                <select class="form-select" name="bulan" required>
                                                    <?php
                                                    $bulanList = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                                                    foreach ($bulanList as $bulan) {
                                                        $selected = ($bulan == $row['bulan']) ? 'selected' : '';
                                                        echo "<option value=\"$bulan\" $selected>$bulan</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="mb-3">
                                                <label for="tipe" class="form-label">Tipe Gaji</label>
                                                <select class="form-select" name="tipe" required>
                                                    <option value="Regular" <?php if ($row['tipe'] == 'Regular') echo 'selected'; ?>>Regular</option>
                                                    <option value="THR" <?php if ($row['tipe'] == 'THR') echo 'selected'; ?>>THR</option>
                                                    <option value="Bonus" <?php if ($row['tipe'] == 'Bonus') echo 'selected'; ?>>Bonus</option>
                                                </select>
                                            </div>

                                            <div class="mb-3">
                                                <label for="slip_link" class="form-label">Link Slip Gaji</label>
                                                <input type="url" class="form-control" name="slip_link" value="<?php echo htmlspecialchars($row['slip_link']); ?>">
                                            </div>

                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan Perubahan</button>
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>


                        <!-- Modal Hapus Gaji -->
                        <div class="modal fade" id="modalDeleteGaji<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="modalDeleteLabel<?php echo $row['id']; ?>" aria-hidden="true">
                            <div class="modal-dialog">
                                <form method="POST" action="">
                                    <input type="hidden" name="hapus_gaji" value="1">
                                    <input type="hidden" name="gaji_id" value="<?php echo $row['id']; ?>">
                                    <div class="modal-content">
                                        <div class="modal-header bg-danger text-white">
                                            <h5 class="modal-title" id="modalDeleteLabel<?php echo $row['id']; ?>">Hapus Gaji Pegawai</h5>
                                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Tutup"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Apakah Anda yakin ingin menghapus data gaji untuk <strong><?php echo htmlspecialchars($row['nama']); ?></strong> bulan <strong><?php echo $row['bulan']; ?> <?php echo $row['tahun']; ?></strong>?</p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-danger"><i class="fas fa-trash-alt"></i> Ya, Hapus</button>
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>


                    <?php endwhile; ?>
                </tbody>
            </table>


            <?php if ($totalPages > 1): ?>
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center mt-3">
                        <!-- Prev -->
                        <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => max(1, $page - 1)])) ?>">Prev</a>
                        </li>

                        <!-- Numbered Pages -->
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= $page == $i ? 'active' : '' ?>">
                                <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>

                        <!-- Next -->
                        <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => min($totalPages, $page + 1)])) ?>">Next</a>
                        </li>
                    </ul>
                </nav>
            <?php endif; ?>


            <!-- Modal Tambah Gaji -->
            <div class="modal fade" id="modalTambahGaji" tabindex="-1" aria-labelledby="modalTambahLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <form method="POST" action="">
                        <input type="hidden" name="tambah_gaji" value="1">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalTambahLabel">Tambah Gaji Pegawai</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                            </div>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="user_id" class="form-label">Nama Pegawai</label>
                                    <select class="form-select" name="user_id" id="user_id" required>
                                        <option value="" disabled selected>-- Pilih Pegawai --</option>
                                        <?php
                                        $pegawaiQuery = $conn->query("SELECT id, nama FROM users WHERE tipe = 'user'");
                                        while ($pegawai = $pegawaiQuery->fetch_assoc()) {
                                            echo '<option value="' . $pegawai['id'] . '">' . htmlspecialchars($pegawai['nama']) . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="tahun" class="form-label">Tahun</label>
                                    <input type="number" class="form-control" name="tahun" id="tahun" value="<?php echo date('Y'); ?>" required>
                                </div>

                                <div class="mb-3">
                                    <label for="bulan" class="form-label">Bulan</label>
                                    <select class="form-select" name="bulan" id="bulan" required>
                                        <option value="" disabled selected>-- Pilih Bulan --</option>
                                        <?php
                                        $bulanList = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                                        foreach ($bulanList as $bulan) {
                                            echo "<option value=\"$bulan\">$bulan</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="tipe" class="form-label">Tipe Gaji</label>
                                    <select class="form-select" name="tipe" id="tipe" required>
                                        <option value="Regular">Regular</option>
                                        <option value="THR">THR</option>
                                        <option value="Bonus">Bonus</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="slip_link" class="form-label">Link Slip Gaji (misal GDrive)</label>
                                    <input type="url" class="form-control" name="slip_link" id="slip_link" placeholder="https://drive.google.com/....">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Modal Import Gaji -->
            <div class="modal fade" id="modalImportGaji" tabindex="-1" aria-labelledby="modalImportLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <form action="gaji.php" method="POST" enctype="multipart/form-data" class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Import Data Gaji</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-info">
                                <strong>Format file:</strong><br>
                                File harus berformat <code>.xlsx</code> atau <code>.xls</code>.<br>
                                Kolom wajib: <code>user_id</code>, <code>tahun</code>, <code>bulan</code>, <code>tipe</code>, <code>slip_link</code><br>
                                Isi bulan berbahasa Indonesia (huruf besar diawal kata)<br>
                                <a href="template_import_gaji.xlsx" download class="btn btn-sm btn-success mt-2">Download Template</a>

                            </div>
                            <div class="mb-3">
                                <label for="fileExcel" class="form-label">Pilih File Excel</label>
                                <input type="file" name="file_excel" id="fileExcel" accept=".xls,.xlsx" class="form-control" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" name="import_gaji" class="btn btn-primary">Import</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        </div>
                    </form>
                </div>
            </div>





        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>



    <script>
        const searchInputNew = document.getElementById('searchInputNew');
        const searchButtonNew = document.getElementById('searchButtonNew');

        // Event listener untuk memperlihatkan tombol ketika input diklik
        searchInputNew.addEventListener('focus', function() {
            searchButtonNew.classList.add('show'); // Tampilkan tombol
            searchInputNew.placeholder = ''; // Hilangkan placeholder
        });

        // Event listener untuk menyembunyikan tombol ketika input kosong
        searchInputNew.addEventListener('blur', function() {
            if (!searchInputNew.value.trim()) {
                searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
            }
        });
    </script>
</body>

</html>