<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');
include(__DIR__ . '/../includes/functions.php');

// Helper to ensure 'Unassigned' unit exists and return its id
function getOrCreateUnassignedUnitId($conn)
{
    $unitName = 'Unassigned';
    $stmt = $conn->prepare('SELECT id FROM unit WHERE unit_name = ? LIMIT 1');
    $stmt->bind_param('s', $unitName);
    $stmt->execute();
    $r = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    if ($r && isset($r['id'])) return (int)$r['id'];
    // Insert new row
    $ins = $conn->prepare('INSERT INTO unit (unit_name) VALUES (?)');
    if ($ins->execute()) {
        $newId = $ins->insert_id;
        $ins->close();
        return (int)$newId;
    }
    $ins->close();
    return null;
}

if (!isAdmin($conn)) {
    header('Location: login.php');
    exit();
}

// count active agendas for sidebar badge
date_default_timezone_set("Asia/Jakarta");
$today = date('Y-m-d');
$nowTime = date('H:i');
$countQuery = "SELECT COUNT(*) as jumlah FROM agenda WHERE tanggal > ? OR (tanggal = ? AND waktu >= ?)";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;

$errors = [];
$success = null;

// Show message based on GET params after redirect
if (!empty($_GET['added'])) $success = 'Penyetuju berhasil ditambahkan.';
if (!empty($_GET['deleted'])) $success = 'Penyetuju berhasil dihapus.';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location: letter-order.php');
    exit();
}

// load the letter_order row for this id
$stmt = $conn->prepare('SELECT lo.id AS lo_id, lo.user_id, lo.supervisor_id, u.nama AS user_name, s.nama AS supervisor_name FROM letter_order lo LEFT JOIN users u on lo.user_id = u.id LEFT JOIN users s on lo.supervisor_id = s.id WHERE lo.id = ? LIMIT 1');
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();
$row = $res ? $res->fetch_assoc() : null;
$stmt->close();
if (!$row) {
    header('Location: letter-order.php');
    exit();
}

// Fetch the selected user's sub_unit_id for later fallbacks
$stmt = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
$stmt->bind_param('i', $row['user_id']);
$stmt->execute();
$u = $stmt->get_result()->fetch_assoc();
$stmt->close();
$selectedUserSubUnitId = isset($u['sub_unit_id']) ? (int)$u['sub_unit_id'] : null;

// Build map
list($map, $nameMap) = buildSupervisorMap($conn);

// Supervisors list
$supervisors = [];
if ($r = $conn->query('SELECT id, nama, jabatan FROM users ORDER BY nama')) {
    $supervisors = $r->fetch_all(MYSQLI_ASSOC);
    $r->free();
}

// Note: no admin unit override in this flow

// Handle inline manage chain add/delete actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['chain_action']) && $_POST['chain_action'] === 'save_chain') {
    $chainUserId = isset($_POST['chain_user_id']) ? (int)$_POST['chain_user_id'] : 0;
    $approverIds = isset($_POST['approver_id']) && is_array($_POST['approver_id']) ? $_POST['approver_id'] : [];
    $urutans = isset($_POST['urutan']) && is_array($_POST['urutan']) ? $_POST['urutan'] : [];
    if ($chainUserId <= 0) $errors[] = 'Pengguna target tidak valid.';
    else {
        $q = $conn->prepare('SELECT tipe FROM users WHERE id = ? LIMIT 1');
        $q->bind_param('i', $chainUserId);
        $q->execute();
        $rowt = $q->get_result()->fetch_assoc();
        $q->close();
        $ctype = isset($rowt['tipe']) ? strtolower(trim($rowt['tipe'])) : null;
        if ($ctype !== 'user') $errors[] = 'Pengguna target tidak valid: hanya pengguna bertipe "user" yang dapat memiliki penyetuju.';
    }
    if (empty($errors)) {
        $pairs = [];
        for ($i = 0; $i < count($approverIds); $i++) {
            $aid = (int)$approverIds[$i];
            $ur = isset($urutans[$i]) ? (int)$urutans[$i] : ($i + 1);
            if ($aid <= 0) continue;
            if ($aid === $chainUserId) {
                $errors[] = 'Penyetuju tidak boleh sama dengan pengguna.';
                break;
            }
            $pairs[] = ['approver_id' => $aid, 'urutan' => $ur];
        }
        if (empty($errors)) {
            // Delete existing chain rows
            $del = $conn->prepare('DELETE FROM approval_chain WHERE user_id = ?');
            $del->bind_param('i', $chainUserId);
            if (!$del->execute()) {
                $errors[] = 'Gagal membersihkan penyetuju lama: ' . $del->error;
            }
            $del->close();
        }
        if (empty($errors)) {
            // Insert new chain rows
            $unassignedUsed = false;
            foreach ($pairs as $p) {
                $unit_id = null;
                $stmt = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
                $stmt->bind_param('i', $chainUserId);
                $stmt->execute();
                $ure = $stmt->get_result()->fetch_assoc();
                $stmt->close();
                $unit_id = isset($ure['sub_unit_id']) ? (int)$ure['sub_unit_id'] : null;
                if ($unit_id === null) {
                    $stmt2 = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
                    $stmt2->bind_param('i', $p['approver_id']);
                    $stmt2->execute();
                    $arr = $stmt2->get_result()->fetch_assoc();
                    $stmt2->close();
                    $appr_unit = isset($arr['sub_unit_id']) ? (int)$arr['sub_unit_id'] : null;
                    if ($appr_unit !== null) $unit_id = $appr_unit;
                }
                if ($unit_id === null) {
                    $unit_id = getOrCreateUnassignedUnitId($conn);
                    $unassignedUsed = true;
                }
                if ($unit_id === null) {
                    $errors[] = 'Tidak dapat menemukan unit untuk penyetuju.';
                    break;
                }
                $ins = $conn->prepare('INSERT INTO approval_chain (unit_id, user_id, approver_id, urutan) VALUES (?, ?, ?, ?)');
                $ins->bind_param('iiii', $unit_id, $chainUserId, $p['approver_id'], $p['urutan']);
                if (!$ins->execute()) {
                    $errors[] = 'Gagal menambahkan penyetuju: ' . $ins->error;
                    $ins->close();
                    break;
                }
                $ins->close();
            }
        }
        if (empty($errors)) {
            $success = 'Daftar penyetuju berhasil disimpan.';
            if (!empty($unassignedUsed)) {
                $success .= ' Perhatian: beberapa penyetuju telah disimpan dengan unit "Unassigned" karena tidak ada unit yang terkait.';
            }
            header('Location: edit-letter-order.php?id=' . (int)$id . '&saved=1');
            exit();
        }
    }
} else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['chain_action'])) {
    $action = $_POST['chain_action'];
    $userIdForChain = (int)$row['user_id'];
    if ($action === 'add') {
        $approver_id = isset($_POST['approver_id']) && $_POST['approver_id'] !== '' ? (int)$_POST['approver_id'] : 0;
        $urutan = isset($_POST['urutan']) ? (int)$_POST['urutan'] : 1;
        if ($approver_id <= 0) $errors[] = 'Penyetuju harus dipilih.';
        if ($approver_id === $userIdForChain) $errors[] = 'Penyetuju tidak boleh sama dengan pengguna.';
        if (empty($errors)) {
            // determine unit by user's sub_unit_id
            $stmt = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
            $stmt->bind_param('i', $userIdForChain);
            $stmt->execute();
            $u = $stmt->get_result()->fetch_assoc();
            $stmt->close();
            $unit_id = isset($u['sub_unit_id']) ? (int)$u['sub_unit_id'] : null;

            // Fallback to approver's sub_unit_id if the user doesn't have one
            if ($unit_id === null) {
                $stmt2 = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
                $stmt2->bind_param('i', $approver_id);
                $stmt2->execute();
                $appr = $stmt2->get_result()->fetch_assoc();
                $stmt2->close();
                $unit_id = isset($appr['sub_unit_id']) ? (int)$appr['sub_unit_id'] : null;
            }

            // validate unit existence; if missing or invalid, prevent insert and show error
            if ($unit_id !== null) {
                $checkUnit = $conn->prepare('SELECT id FROM unit WHERE id = ? LIMIT 1');
                $checkUnit->bind_param('i', $unit_id);
                $checkUnit->execute();
                $unitRow = $checkUnit->get_result()->fetch_assoc();
                $checkUnit->close();
                if (!$unitRow) {
                    $errors[] = 'Gagal menambahkan penyetuju: Unit pengguna tidak ditemukan. Silakan set sub_unit_id pada profil pengguna terlebih dahulu.';
                }
            }
            if (empty($errors)) {
                $ins = $conn->prepare('INSERT INTO approval_chain (unit_id, user_id, approver_id, urutan) VALUES (?, ?, ?, ?)');
                $ins->bind_param('iiii', $unit_id, $userIdForChain, $approver_id, $urutan);
                if ($ins->execute()) {
                    $success = 'Penyetuju berhasil ditambahkan.';
                    header('Location: edit-letter-order.php?id=' . (int)$id . '&added=1');
                    exit();
                } else {
                    $errors[] = 'Gagal menambahkan penyetuju: ' . $ins->error;
                }
                $ins->close();
            }
        }
    } elseif ($action === 'delete') {
        $aid = isset($_POST['chain_id']) ? (int)$_POST['chain_id'] : 0;
        if ($aid > 0) {
            $del = $conn->prepare('DELETE FROM approval_chain WHERE id = ? LIMIT 1');
            $del->bind_param('i', $aid);
            if ($del->execute()) {
                $success = 'Penyetuju berhasil dihapus.';
                header('Location: edit-letter-order.php?id=' . (int)$id . '&deleted=1');
                exit();
            } else {
                $errors[] = 'Gagal menghapus penyetuju: ' . $del->error;
            }
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['chain_action'])) {
    $supervisorId = isset($_POST['supervisor_id']) && $_POST['supervisor_id'] !== '' ? (int)$_POST['supervisor_id'] : null;

    if ($supervisorId !== null && $supervisorId == $row['user_id']) $errors[] = 'Atasan tidak boleh sama dengan pengguna.';
    // reload map then check cycle if needed
    list($map, $nameMap) = buildSupervisorMap($conn);
    if (createsCycle((int)$row['user_id'], $supervisorId, $map)) $errors[] = 'Mengatur atasan ini akan menyebabkan siklus pada urutan.';

    if (empty($errors)) {
        $up = $conn->prepare('UPDATE letter_order SET supervisor_id = ?, updated_by = ? WHERE id = ?');
        // admin id
        $adminId = null;
        if (isset($_SESSION['username'])) {
            $q = $conn->prepare('SELECT id FROM users WHERE username = ? LIMIT 1');
            $q->bind_param('s', $_SESSION['username']);
            $q->execute();
            $rr = $q->get_result();
            $r2 = $rr ? $rr->fetch_assoc() : null;
            $q->close();
            $adminId = $r2['id'] ?? null;
        }
        $up->bind_param('iii', $supervisorId, $adminId, $id);
        if ($up->execute()) {
            $success = 'Berhasil diperbarui.';
            header('Location: letter-order.php?updated=1');
            exit();
            // reload row
            $stmt = $conn->prepare('SELECT lo.id AS lo_id, lo.user_id, lo.supervisor_id, u.nama AS user_name, s.nama AS supervisor_name FROM letter_order lo LEFT JOIN users u on lo.user_id = u.id LEFT JOIN users s on lo.supervisor_id = s.id WHERE lo.id = ? LIMIT 1');
            $stmt->bind_param('i', $id);
            $stmt->execute();
            $res = $stmt->get_result();
            $row = $res ? $res->fetch_assoc() : null;
            $stmt->close();
            // update map
            list($map, $nameMap) = buildSupervisorMap($conn);
        } else {
            $errors[] = 'Gagal memperbarui: ' . $up->error;
        }
        $up->close();
    }
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Edit Urutan Surat</title>
    <link href="img/baru/logojp.png" rel="icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        /* Copied site styles from record-letter for consistent layout */
        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        .table thead {
            background-color: #0047ab;
            color: #fff;
            text-transform: uppercase;
            font-weight: bold;
        }

        .table thead th {
            background-color: #0c50e1;
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            overflow-y: auto;
            overflow-x: hidden;
            padding-bottom: 20px;
            margin-bottom: 0;
            scrollbar-width: thin;
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
                <a href="manajemen-surat.php"><i class="fas fa-folder-open"></i> Manajemen Data Surat</a>
                <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
                <a href="manage-inisial.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'manage-inisial.php') ? 'active' : ''; ?>"><i class="fas fa-signature"></i> Manajemen Inisial</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>
            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu">
                <i class="fas fa-images" class="active"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <div id="mainContent" class="container-fluid py-3">
            <h3>Ubah Urutan Surat - <?= htmlspecialchars($row['user_name']) ?></h3>
            <a href="letter-order.php" class="btn btn-secondary mb-3">Kembali</a>

            <?php if ($success): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <?php endif; ?>
            <?php if (!empty($errors)): ?>
                <div class="alert alert-danger">
                    <ul><?php foreach ($errors as $e) echo '<li>' . htmlspecialchars($e) . '</li>'; ?></ul>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">Nama User</label>
                    <div class="form-control"><?= htmlspecialchars($row['user_name']) ?></div>
                </div>
                <div class="mb-3">
                    <label class="form-label">Nama Atasan (Supervisor)</label>
                    <select class="form-select" name="supervisor_id">
                        <option value="">-- No Supervisor --</option>
                        <?php foreach ($supervisors as $s): ?>
                            <option value="<?= (int)$s['id'] ?>" <?= ((int)$row['supervisor_id'] === (int)$s['id']) ? 'selected' : '' ?>><?= htmlspecialchars($s['nama']) ?><?= $s['jabatan'] ? ' - ' . htmlspecialchars($s['jabatan']) : '' ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Simpan</button>
            </form>

            <!-- Inline Approver Chain Management -->
            <hr>
            <h4>Daftar Atasan</h4>
            <?php
            $rowsChain = [];
            $stmt = $conn->prepare('SELECT ac.id, ac.unit_id, ac.user_id, ac.approver_id, ac.urutan, u.nama as approver_name, un.unit_name as unit_name FROM approval_chain ac LEFT JOIN users u on ac.approver_id = u.id LEFT JOIN unit un on ac.unit_id = un.id WHERE ac.user_id = ? ORDER BY ac.urutan');
            $stmt->bind_param('i', $row['user_id']);
            $stmt->execute();
            $res = $stmt->get_result();
            if ($res) $rowsChain = $res->fetch_all(MYSQLI_ASSOC);
            $stmt->close();
            ?>
            <?php
            $supervisorOptionsHtml = '';
            foreach ($supervisors as $s) {
                if ((int)$s['id'] === (int)$row['user_id']) continue;
                $supervisorOptionsHtml .= '<option value="' . (int)$s['id'] . '">' . htmlspecialchars($s['nama']);
                if (!empty($s['jabatan'])) $supervisorOptionsHtml .= ' - ' . htmlspecialchars($s['jabatan']);
                $supervisorOptionsHtml .= '</option>';
            }
            ?>
            <form method="POST" id="chainForm">
                <input type="hidden" name="chain_action" value="save_chain">
                <input type="hidden" name="chain_user_id" value="<?= (int)$row['user_id'] ?>">
                <div id="approversContainer">
                    <?php $i = 1;
                    foreach ($rowsChain as $rr): ?>
                        <div class="mb-3 approver-row">
                            <label class="form-label">Atasan <?= $i ?></label>
                            <select name="approver_id[]" class="form-select mb-1">
                                <option value="">-- Pilih Penyetuju --</option>
                                <?php foreach ($supervisors as $s): if ((int)$s['id'] === (int)$row['user_id']) continue; ?>
                                    <option value="<?= (int)$s['id'] ?>" <?= ((int)$rr['approver_id'] === (int)$s['id']) ? 'selected' : '' ?>><?= htmlspecialchars($s['nama']) ?><?= $s['jabatan'] ? ' - ' . htmlspecialchars($s['jabatan']) : '' ?></option>
                                <?php endforeach; ?>
                            </select>
                            <input type="hidden" name="urutan[]" value="<?= (int)$rr['urutan'] ?>" />
                            <button type="button" class="btn btn-sm btn-danger mt-1 remove-approver">Hapus</button>
                        </div>
                    <?php $i++;
                    endforeach; ?>
                </div>
                <div class="mb-3">
                    <button id="addApproverBtn" type="button" class="btn btn-secondary">Tambah Atasan</button>
                    <button type="submit" class="btn btn-primary">Simpan Atasan</button>
                </div>
            </form>
            <!-- Old single-add form removed; use the Atasan list above to add/update approvers -->
            <script>
                const supervisorOptions = <?= json_encode($supervisorOptionsHtml) ?>;
                document.addEventListener('DOMContentLoaded', function() {
                    const container = document.getElementById('approversContainer');
                    const addBtn = document.getElementById('addApproverBtn');
                    addBtn.addEventListener('click', function() {
                        const index = container.querySelectorAll('.approver-row').length + 1;
                        const row = document.createElement('div');
                        row.className = 'mb-3 approver-row';
                        row.innerHTML = `\n                        <label class="form-label">Atasan ${index}</label>\n                        <select name="approver_id[]" class="form-select mb-1">${supervisorOptions}</select>\n                        <input type="hidden" name="urutan[]" value="${index}">\n                        <button type="button" class="btn btn-sm btn-danger mt-1 remove-approver">Hapus</button>\n                    `;
                        container.appendChild(row);
                    });
                    container.addEventListener('click', function(e) {
                        if (e.target && e.target.matches('.remove-approver')) {
                            const row = e.target.closest('.approver-row');
                            row.remove();
                            const rows = container.querySelectorAll('.approver-row');
                            rows.forEach((r, i) => {
                                const label = r.querySelector('.form-label');
                                const input = r.querySelector('input[type=hidden]');
                                label.textContent = `Atasan ${i+1}`;
                                if (input) input.value = i + 1;
                            });
                        }
                    });
                });
            </script>
            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
        </div>
    </div>
</body>

</html>