<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');
include(__DIR__ . '/../includes/functions.php');

if (!isAdmin($conn)) {
    header('Location: ../login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: letter-order.php');
    exit();
}

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) {
    header('Location: letter-order.php?error=invalid_id');
    exit();
}

// find mapping
$st = $conn->prepare('SELECT user_id FROM letter_order WHERE id = ? LIMIT 1');
$st->bind_param('i', $id);
$st->execute();
$res = $st->get_result();
$row = $res ? $res->fetch_assoc() : null;
$st->close();
if (!$row) {
    header('Location: letter-order.php?error=not_found');
    exit();
}
$userId = (int)$row['user_id'];

// delete cascade: remove office rows created by this user and related files
try {
    $conn->begin_transaction();

    $q = $conn->prepare('SELECT id, file_surat, lampiran_path, qr_code FROM office WHERE dibuat_oleh = ?');
    $q->bind_param('i', $userId);
    $q->execute();
    $res2 = $q->get_result();
    $offices = $res2->fetch_all(MYSQLI_ASSOC);
    $q->close();

    foreach ($offices as $o) {
        $fileSurat = $o['file_surat'] ?? null;
        $lampiranPath = $o['lampiran_path'] ?? null;
        $qrCode = $o['qr_code'] ?? null;

        if (!empty($fileSurat)) {
            $abs = __DIR__ . '/' . ltrim($fileSurat, '/');
            if (is_file($abs)) @unlink($abs);
        }
        if (!empty($lampiranPath)) {
            $decoded = json_decode($lampiranPath, true);
            if (is_array($decoded)) {
                foreach ($decoded as $p) {
                    $abs2 = __DIR__ . '/' . ltrim($p, '/');
                    if (is_file($abs2)) @unlink($abs2);
                }
            } else {
                $abs2 = __DIR__ . '/' . ltrim($lampiranPath, '/');
                if (is_file($abs2)) @unlink($abs2);
            }
        }
        if (!empty($qrCode)) {
            $abs3 = __DIR__ . '/' . ltrim($qrCode, '/');
            if (is_file($abs3)) @unlink($abs3);
        }
    }

    // delete office rows
    $d = $conn->prepare('DELETE FROM office WHERE dibuat_oleh = ?');
    $d->bind_param('i', $userId);
    if (!$d->execute()) {
        throw new Exception('Failed deleting office rows: ' . $d->error);
    }
    $d->close();

    // delete letter_order row
    $del = $conn->prepare('DELETE FROM letter_order WHERE id = ?');
    $del->bind_param('i', $id);
    if (!$del->execute()) {
        throw new Exception('Failed deleting letter_order: ' . $del->error);
    }
    $del->close();

    $conn->commit();
    header('Location: letter-order.php?deleted=1');
    exit();
} catch (Exception $ex) {
    $conn->rollback();
    error_log('DELETE_LETTER_ORDER_FAIL: ' . $ex->getMessage());
    header('Location: letter-order.php?error=failed_delete');
    exit();
}
