<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');

if (!isset($_SESSION['username'])) {
    header('Location: ../login.php');
    exit();
}

// Cek apakah tipe user adalah admin
$username = $_SESSION['username'];
$query = "SELECT tipe, nama FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['tipe'] !== 'admin') {
    header('Location: ../login.php');
    exit();
}




function sortableHeader($label, $key, $currentSortBy, $currentOrder, $get)
{
    $nextOrder = ($currentSortBy === $key && $currentOrder === 'ASC') ? 'DESC' : 'ASC';
    $icon = '<i class="fas fa-sort ms-1"></i>';
    if ($currentSortBy === $key) {
        $icon = $currentOrder === 'ASC'
            ? '<i class="fas fa-arrow-up ms-1"></i>'
            : '<i class="fas fa-arrow-down ms-1"></i>';
    }
    $params = array_merge($get, ['sort_by' => $key, 'sort_order' => $nextOrder]);
    $link = '?' . http_build_query($params);
    return "<a href=\"$link\" class=\"text-warning text-decoration-none\">$label $icon</a>";
}

// Sorting
$sort_by = $_GET['sort_by'] ?? 'id';
$sort_order = $_GET['sort_order'] ?? 'ASC';
$allowedSort = [
    'id' => 'id',
    'nama' => 'nama',
    'username' => 'username',
    'email' => 'email',
    'tipe' => 'tipe',
    'jabatan' => 'jabatan',
    'gender' => 'gender',
    'created_at' => 'created_at'
];
$sort_column = $allowedSort[$sort_by] ?? 'created_at';
$next_order = ($sort_order === 'ASC') ? 'DESC' : 'ASC';






date_default_timezone_set("Asia/Jakarta"); // Set timezone ke Jakarta
$hour = date("H"); // Mendapatkan jam saat ini (format 24 jam)

if ($hour >= 5 && $hour < 12) {
    $greeting = "pagi";
    $icon = "fa-sun"; // Ikon matahari
    $color = "#FFD700"; // Warna kuning
} elseif ($hour >= 12 && $hour < 15) {
    $greeting = "siang";
    $icon = "fa-cloud-sun"; // Ikon matahari berawan
    $color = "#FF8C00"; // Warna oranye
} elseif ($hour >= 15 && $hour < 18) {
    $greeting = "sore";
    $icon = "fa-cloud"; // Ikon awan
    $color = "#1E90FF"; // Warna jingga
} else {
    $greeting = "malam";
    $icon = "fa-moon"; // Ikon bulan
    $color = "#0800A9FF"; // Warna biru malam
}





// Menghitung jumlah dari setiap tabel
$totalVisitCount = 0;
$totalBerita = 0;
$totalGerbang = 0;
$totalSosial = 0;

try {
    // Query untuk tabel counter: Menghitung total visit_count
    $result = $conn->query("SELECT SUM(visit_count) AS total FROM counter");
    $row = $result->fetch_assoc();
    $totalVisitCount = $row['total'] ?? 0;

    // Query untuk tabel berita
    $result = $conn->query("SELECT COUNT(*) AS total FROM berita");
    $row = $result->fetch_assoc();
    $totalBerita = $row['total'] ?? 0;

    // Query untuk tabel gerbang: Menghitung total jumlah entri
    $result = $conn->query("SELECT COUNT(*) AS total FROM gerbang");
    if (!$result) {
        throw new Exception("Query tabel gerbang gagal: " . $conn->error);
    }
    $row = $result->fetch_assoc();
    $totalGerbang = $row['total'] ?? 0;

    // Query untuk tabel sosial
    $result = $conn->query("SELECT COUNT(*) AS total FROM sosial");
    $row = $result->fetch_assoc();
    $totalSosial = $row['total'] ?? 0;
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}



$name = isset($_SESSION['name']) ? $_SESSION['name'] : 'Datang Admin'; // Pastikan nama pengguna di sesi

date_default_timezone_set('Asia/Jakarta');
$today = date('Y-m-d');
$nowTime = date('H:i');

// Hitung agenda aktif (hari ini dan akan datang)
$countQuery = "
    SELECT COUNT(*) as jumlah 
    FROM agenda 
    WHERE tanggal > ? 
       OR (tanggal = ? AND waktu >= ?)
";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;


$subUnitListCreate = $conn->query("SELECT id, sub_unit_name FROM sub_unit ORDER BY sub_unit_name ASC");
$subUnitList = $conn->query("SELECT id, sub_unit_name FROM sub_unit ORDER BY sub_unit_name ASC");

// Handle edit user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_user'])) {
    $id = $_POST['id'];
    $username_input = $_POST['username'] ?? null;
    $password_input = $_POST['password'] ?? '';
    $nama_input = $_POST['nama'] ?? null;
    $email_input = $_POST['email'] ?? null;
    $tipe_input = $_POST['tipe'] ?? null;
    $jabatan_input = $_POST['jabatan'] ?? null;
    $gender_input = $_POST['gender'] ?? null;

    // Jika sub_unit_id kosong, set NULL
    $sub_unit_id = !empty($_POST['sub_unit_id']) ? $_POST['sub_unit_id'] : null;

    $akses_input = [
        'berita' => isset($_POST['akses_berita']) ? 'on' : 'off',
        'sosial' => isset($_POST['akses_sosial']) ? 'on' : 'off',
        'gaji' => isset($_POST['akses_gaji']) ? 'on' : 'off',
        'surat' => isset($_POST['akses_surat']) ? 'on' : 'off',
        'agenda' => isset($_POST['akses_agenda']) ? 'on' : 'off',
        'todolist' => isset($_POST['akses_todolist']) ? 'on' : 'off'
    ];
    $akses_json = json_encode($akses_input);

    $stmt_old = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt_old->bind_param("i", $id);
    $stmt_old->execute();
    $result_old = $stmt_old->get_result();
    $old = $result_old->fetch_assoc();

    $password = $password_input !== '' ? password_hash($password_input, PASSWORD_DEFAULT) : $old['password'];

    $sql = "UPDATE users 
            SET username = ?, password = ?, nama = ?, email = ?, tipe = ?, jabatan = ?, gender = ?, sub_unit_id = ?, access_modul = ? 
            WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "sssssssssi",
        $username_input,
        $password,
        $nama_input,
        $email_input,
        $tipe_input,
        $jabatan_input,
        $gender_input,
        $sub_unit_id,
        $akses_json,
        $id
    );

    if ($stmt->execute()) {
        if ($_SESSION['username'] === $old['username'] && $username_input !== $old['username']) {
            $_SESSION['username'] = $username_input;
        }
        echo "<script>alert('Data berhasil diupdate'); window.location.href='dashboard.php';</script>";
    } else {
        echo "<script>alert('Data gagal diupdate');</script>";
    }
}







// Handle delete user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
    $delete_id = $_POST['delete_user_id'];

    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $delete_id);

    if ($stmt->execute()) {
        echo "<script>alert('User berhasil dihapus'); window.location.href='dashboard.php';</script>";
    } else {
        echo "<script>alert('Gagal menghapus user');</script>";
    }
}

// Handle tambah user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_user'])) {
    $nama = $_POST['nama'] ?? null;
    $username = $_POST['username'] ?? null;
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $email = $_POST['email'] ?? null;
    $tipe = $_POST['tipe'] ?? null;
    $jabatan = $_POST['jabatan'] ?? null;
    $gender = $_POST['gender'] ?? null;

    // Jika sub_unit_id kosong, set NULL
    $sub_unit_id = !empty($_POST['sub_unit_id']) ? $_POST['sub_unit_id'] : null;

    // Akses modul dari checkbox
    $akses = [
        'berita' => isset($_POST['akses_berita']) ? 'on' : 'off',
        'sosial' => isset($_POST['akses_sosial']) ? 'on' : 'off',
        'gaji' => isset($_POST['akses_gaji']) ? 'on' : 'off',
        'surat' => isset($_POST['akses_surat']) ? 'on' : 'off',
        'agenda' => isset($_POST['akses_agenda']) ? 'on' : 'off',
        'todolist' => isset($_POST['akses_todolist']) ? 'on' : 'off'
    ];
    $akses_json = json_encode($akses);

    $stmt = $conn->prepare("INSERT INTO users (nama, username, password, email, tipe, jabatan, gender, sub_unit_id, access_modul) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    // Gunakan 'i' hanya jika sub_unit_id ada, jika NULL gunakan PDO bind_param null
    $stmt->bind_param(
        "sssssssis",
        $nama,
        $username,
        $password,
        $email,
        $tipe,
        $jabatan,
        $gender,
        $sub_unit_id,
        $akses_json
    );

    if ($stmt->execute()) {
        echo "<script>alert('User berhasil ditambahkan'); window.location.href='dashboard.php';</script>";
    } else {
        echo "<script>alert('Gagal menambahkan user');</script>";
    }
}








$limitOptions = [10, 50, 'All'];
$selectedLimit = isset($_GET['limit']) ? $_GET['limit'] : 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;

// Hitung total data
$search = $_GET['search'] ?? '';
$searchSql = '';
$searchParam = '';

if (!empty($search)) {
    $search = $conn->real_escape_string($search);
    $searchSql = "WHERE users.id LIKE '%$search%' 
        OR users.nama LIKE '%$search%' 
        OR users.username LIKE '%$search%' 
        OR users.email LIKE '%$search%' 
        OR users.tipe LIKE '%$search%' 
        OR users.jabatan LIKE '%$search%'";
}

// Hitung total data hasil pencarian
$totalDataSql = "SELECT COUNT(*) AS total FROM users $searchSql";
$totalData = $conn->query($totalDataSql)->fetch_assoc()['total'];





$totalPages = $selectedLimit === 'All' ? 1 : ceil($totalData / $selectedLimit);
$offset = ($page - 1) * ($selectedLimit === 'All' ? $totalData : $selectedLimit);

// Ambil data sesuai paginasi
$sql = "SELECT users.*, sub_unit.sub_unit_name 
        FROM users 
        LEFT JOIN sub_unit ON users.sub_unit_id = sub_unit.id 
        $searchSql 
        ORDER BY $sort_column $sort_order " .
    ($selectedLimit === 'All' ? "" : "LIMIT $offset, $selectedLimit");

$result = $conn->query($sql);
if (!$result) {
    die("Query error: " . $conn->error); // tampilkan detail error SQL saat dev
}


?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Favicon -->
    <link href="img/baru/logojp.png" rel="icon">

    <title>Dashboard</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .greeting {
            text-align: center;
            color: <?php echo $color; ?>;
            animation: fadeIn 2s ease-in-out;
        }

        .icon {
            margin-top: 40px;
            font-size: 50px;
            margin-bottom: 0px;
            animation: bounce 1.5s infinite;
        }

        @keyframes bounce {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        .sidebar {
            background-color: #0c50e1;
            color: white;
            min-height: 100vh;
            padding: 15px;
        }

        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #ffc107;
            color: #0047ab;
        }

        .btn-success {
            background-color: #ffc107;
            /* Kuning mencolok */
            border-color: #ffc107;
            color: #0047ab;
            font-weight: bold;
        }

        /* Warna untuk header tabel */
        .table thead {
            background-color: #0047ab;
            /* Biru Jasamarga */
            color: #0c50e1;
            text-transform: uppercase;
            font-weight: bold;
            color: #ffc107;
        }

        .table thead th {
            background-color: #0c50e1;
            /* Biru Jasamarga */
            color: #ffc107;
        }

        .sidebar-animated {
            background-color: #001eff;
            ;
            padding: 20px 10px;
            font-family: Arial, sans-serif;
            height: 100vh;
            width: 250px;
            transition: all 0.3s ease;
            max-height: 100vh;
            /* Limits sidebar height to viewport */
            overflow-y: auto;
            /* Enables vertical scroll */
            overflow-x: hidden;
            /* Hides horizontal scroll */
            padding-bottom: 20px;
            /* Adds extra padding to avoid cut-off */
            margin-bottom: 0;
            /* Ensures no unwanted margin at the bottom */
            scrollbar-width: thin;
        }

        /* Optional: Styling untuk scrollbar pada Chrome, Edge, dan Safari */
        .sidebar-animated::-webkit-scrollbar {
            width: 8px;
            /* Mengatur lebar scrollbar */
        }

        .sidebar-animated::-webkit-scrollbar-thumb {
            background-color: #e1b12c;
            /* Warna scrollbar */
            border-radius: 10px;
            /* Membuat sudut melengkung */
        }

        .sidebar-animated::-webkit-scrollbar-thumb:hover {
            background-color: #ffc107;
            /* Warna scrollbar saat di-hover */
        }

        .sidebar-animated a {
            color: #FFFFFFFF;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .sidebar-animated a:hover {
            background-color: #ffc107;
            color: #fff;
            transform: translateX(5px);
        }

        .sidebar-animated a i {
            margin-right: 10px;
        }

        .sidebar-animated .submenu-toggle {
            cursor: pointer;
            transition: color 0.3s;
        }

        .sidebar-animated .submenu-toggle:hover .arrow-icon {
            transform: rotate(90deg);
            color: #001eff;
        }

        .sidebar-animated .submenu {
            padding-left: 1px;
            overflow: hidden;
            transition: max-height 0.4s ease;
        }

        .sidebar-animated .collapse.show {
            max-height: 300px;
            /* adjust as needed */
            transition: max-height 0.4s ease-in;
        }

        .arrow-icon {
            margin-left: auto;
            transition: transform 0.3s;
        }

        /* Hover and animation effects for submenu */
        .submenu a {
            font-size: 16px;
            color: #FFFFFFFF;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .submenu a:hover {
            color: #001eff;
            transform: translateX(5px);
        }

        /* Sidebar active link style */
        .sidebar-animated a.active {
            background-color: #ffc107;
            /* Warna latar belakang khusus untuk menu aktif */
            color: #fff;
            /* Warna teks untuk menu aktif */
            font-weight: bold;
        }

        .sidebar-animated a.active i {
            color: #fff;
            /* Warna ikon untuk menu aktif */
        }

        /* Navbar custom styling */
        .navbar-custom {
            background-color: #001eff;
            /* Same as sidebar background color */
            transition: background-color 0.3s ease;
            padding: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Adds a subtle shadow */
        }

        /* Logo and Sidebar Toggle */
        .navbar-custom .navbar-brand img {
            transition: transform 0.3s ease;
        }

        .navbar-custom .navbar-brand:hover img {
            transform: scale(1.05);
        }

        /* Toggle Sidebar button */
        .toggle-sidebar-btn {
            color: #fff;
            font-size: 1.3rem;
            cursor: pointer;
            margin-left: 10px;
            transition: color 0.3s ease;
        }

        .toggle-sidebar-btn:hover {
            color: #ffc107;
        }



        /* Animasi untuk kartu */
        @keyframes fadeInUp {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }

            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .highlight-card {
            border-radius: 15px;
            /* Membuat sudut melengkung */
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            animation: fadeInUp 0.8s ease-in-out;
        }

        /* Hover efek */
        .highlight-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        /* Gaya untuk teks */
        .highlight-card h3 {
            font-size: 2.5rem;
            font-weight: bold;
            margin: 0;
        }

        .highlight-card p {
            font-size: 1.1rem;
            margin-top: 5px;
            opacity: 0.9;
        }

        /* Footer styling */
        .highlight-card .card-footer {
            background: rgba(0, 0, 0, 0.1);
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        }

        .highlight-card .card-footer a {
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s ease;
        }

        .highlight-card .card-footer a:hover {
            color: #ffd700;
            /* Warna emas saat hover */
        }

        /* Animasi untuk ikon */
        .highlight-card i {
            animation: bounce 1.5s infinite;
        }

        /* Bounce animasi untuk ikon */
        @keyframes bounce {

            0%,
            20%,
            50%,
            80%,
            100% {
                transform: translateY(0);
            }

            40% {
                transform: translateY(-10px);
            }

            60% {
                transform: translateY(-5px);
            }
        }

        .pagination .page-link {
            color: #007bff;
        }

        .pagination .active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }


        .search-container-new {
            position: relative;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .search-box-new {
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .search-input-new {
            border-radius: 25px;
            padding: 8px 12px;
            border: 1px solid #ced4da;
            background-color: #ffc107;
            color: #001eff;
            transition: width 0.4s ease, box-shadow 0.3s ease;
            width: 184px;
        }

        .search-input-new::placeholder {
            color: #001eff;
            font-style: italic;
            opacity: 0.8;
        }

        .search-input-new:focus {
            width: 250px;
            background-color: #ffffff;
            border-color: #ffc107;
            box-shadow: 0 0 8px rgba(255, 193, 7, 0.6);
            /* Glow kuning */
            outline: none;
        }

        .search-btn-new {
            background-color: #001eff;
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 6px 20px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: none;
        }

        .search-btn-new.show {
            display: inline-block;
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php" class="active"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php"><i class="fas fa-folder-open"></i> Record Surat</a>
                <a href="manajemen-surat.php"><i class="fas fa-cog"></i> Manajemen Data Surat</a>
                <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
                <a href="manage-inisial.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'manage-inisial.php') ? 'active' : ''; ?>"><i class="fas fa-signature"></i> Manajemen Inisial</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer </a>
                <a href="header.php"><i class="fas fa-heading"></i> Header </a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home </a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar </a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil </a>
                <a href="trav.php" class=""><i class="fas fa-font"></i> Travoy </a>
                <a href="jaringan.php" class=""><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php" class=""><i class="fas fa-comments"></i> Chatbot </a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>


            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-toggle="collapse">
                <i class="fas fa-images" class="active"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>
            <a href="/jasa_marga/auth/logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <!-- Main Content -->
        <div class="flex-grow-1 p-3">
            <div class="greeting">
                <i class="fas <?php echo $icon; ?> icon" style="color: <?php echo $color; ?>;"></i>
            </div>
            <h1 class="text-center mt-3 mb-2" style="color: blue;">Selamat, <?php echo htmlspecialchars($name); ?>!</h1>
            <div class="greeting">
                <p class="mb-4">Selamat <?php echo ucfirst($greeting); ?></p> <!-- Menggunakan ucfirst untuk kapitalisasi pertama -->
            </div>


            <div id="mainContent" class="content-container">
                <div class="dashboard-content">
                    <div class="row">
                        <!-- Card 1: Total Visit Count -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card highlight-card bg-warning text-white shadow-lg">
                                <div class="card-body d-flex align-items-center justify-content-between">
                                    <div>
                                        <h3><?= number_format($totalVisitCount) ?></h3>
                                        <p>Total <br>Visitor Counter</p>
                                    </div>
                                    <i class="fas fa-chart-line fa-3x text-light"></i>
                                </div>

                            </div>
                        </div>

                        <!-- Card 2: Berita -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card highlight-card bg-primary text-white shadow-lg">
                                <div class="card-body d-flex align-items-center justify-content-between">
                                    <div>
                                        <h3><?= number_format($totalBerita) ?></h3>
                                        <p>Total Berita</p>
                                    </div>
                                    <i class="fas fa-newspaper fa-3x text-light"></i>
                                </div>
                                <div class="card-footer d-flex align-items-center justify-content-between">
                                    <a class="small text-white stretched-link" href="berita.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                </div>
                            </div>
                        </div>

                        <!-- Card 3: Gerbang -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card highlight-card bg-primary text-white shadow-lg">
                                <div class="card-body d-flex align-items-center justify-content-between">
                                    <div>
                                        <h3><?= number_format($totalGerbang) ?></h3>
                                        <p>Total Gerbang</p>
                                    </div>
                                    <i class="fas fa-door-open fa-3x text-light"></i>
                                </div>
                                <div class="card-footer d-flex align-items-center justify-content-between">
                                    <a class="small text-white stretched-link" href="gerbang.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                </div>
                            </div>
                        </div>


                        <!-- Card 4: Sosial -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card highlight-card bg-success text-white shadow-lg">
                                <div class="card-body d-flex align-items-center justify-content-between">
                                    <div>
                                        <h3><?= number_format($totalSosial) ?></h3>
                                        <p>Total Tanggung Jawab</p>
                                    </div>
                                    <i class="fas fa-users fa-3x text-light"></i>
                                </div>
                                <div class="card-footer d-flex align-items-center justify-content-between">
                                    <a class="small text-white stretched-link" href="sosial.php">lihat detail.. <i class="fas fa-info-circle ml-1"></i></a>
                                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <h2 class="text-center">Data Pengguna</h2>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <form method="get" class="d-flex align-items-center me-3"> <!-- Tambahkan me-3 di sini -->
                        <label class="me-1 fw-bold">Show</label>
                        <select name="limit" onchange="this.form.submit()" class="form-select form-select-sm w-auto">
                            <?php foreach ($limitOptions as $option): ?>
                                <option value="<?= $option ?>" <?= $selectedLimit == $option ? 'selected' : '' ?>>
                                    <?= $option ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </form>

                    <div class="search-container-new">
                        <form method="GET" action="" class="search-box-new me-3">
                            <input
                                type="text"
                                id="searchInputNew"
                                name="search"
                                class="search-input-new me-1"
                                placeholder="Tap untuk mencari..."
                                value="<?php echo htmlspecialchars($_GET['search'] ?? ''); ?>">
                            <button type="submit" id="searchButtonNew" class="search-btn-new">
                                <i class="fas fa-search"></i> Cari
                            </button>
                        </form>
                    </div>
                </div>
                <div>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createUserModal">
                        <i class="fas fa-user-plus"></i> Tambah User
                    </button>
                </div>
            </div>


            <table class="table table-bordered">
                <thead>
                    <tr class="text-center text-bold">
                        <th><?= sortableHeader('Id', 'id', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Nama', 'nama', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Username', 'username', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Email', 'email', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Tipe', 'tipe', $sort_by, $sort_order, $_GET) ?></th>
                        <th><?= sortableHeader('Jabatan', 'jabatan', $sort_by, $sort_order, $_GET) ?></th>
                        <th>Sub Unit</th>

                        <th><?= sortableHeader('Gender', 'gender', $sort_by, $sort_order, $_GET) ?></th>
                        <th>Akses Modul</th>
                        <th><?= sortableHeader('Dibuat Pada', 'created_at', $sort_by, $sort_order, $_GET) ?></th>
                        <th>Tombol</th>
                    </tr>
                </thead>

                <tbody>
                    <?php
                    // Sudah digantikan oleh $result dari query limit & offset di atas


                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<tr class='text-center'>";
                            echo "<td>" . $row['id'] . "</td>";

                            // Nama
                            echo "<td>" . (!empty($row['nama']) ? htmlspecialchars($row['nama']) : '-') . "</td>";
                            // Username & password
                            echo "<td>" . htmlspecialchars($row['username']) . "</td>";


                            // Email
                            echo "<td>";
                            if (!empty($row['email'])) {
                                $email = htmlspecialchars($row['email']);
                                echo "<a href='mailto:$email' class='text-primary text-decoration-none'>
                            <i class='fas fa-envelope'></i> $email
                        </a>";
                            } else {
                                echo "-";
                            }
                            echo "</td>";


                            // Tipe user tampil khusus
                            if ($row['tipe'] === 'admin') {
                                echo "<td style='color: blue; font-weight:bold;'>" . strtoupper($row['tipe']) . "</td>";
                            } elseif ($row['tipe'] === 'editor') {
                                echo "<td><p class='card mt-2 text-white text-center bg-primary'>Editor</p></td>";
                            } elseif ($row['tipe'] === 'user') {
                                echo "<td><p class='card mt-2 text-dark text-center bg-warning'>User</p></td>";
                            } else {
                                echo "<td>-</td>";
                            }

                            // Jabatan
                            echo "<td>" . htmlspecialchars($row['jabatan'] ?? '-') . "</td>";
                            // Sub Unit
                            echo "<td>" . (!empty($row['sub_unit_name']) ? htmlspecialchars($row['sub_unit_name']) : '-') . "</td>";


                            // Gender dengan ikon
                            if ($row['gender'] === 'male') {
                                echo "<td style='color: #ffc107'><i class='fa fa-male' aria-hidden='true'></i></td>";
                            } elseif ($row['gender'] === 'female') {
                                echo "<td style='color: blue'><i class='fa fa-female' aria-hidden='true'></i></td>";
                            } else {
                                echo "<td>-</td>";
                            }

                            // Akses modul
                            $akses_aktif = [];
                            if (!empty($row['access_modul'])) {
                                $access = json_decode($row['access_modul'], true);
                                if (is_array($access)) {
                                    foreach ($access as $modul => $status) {
                                        if ($status === 'on') {
                                            if ($modul === 'sosial') {
                                                $akses_aktif[] = 'Tanggung Jawab';
                                            } elseif ($modul === 'todolist') {
                                                $akses_aktif[] = 'To do list';
                                            } else {
                                                $akses_aktif[] = ucfirst($modul);
                                            }
                                        }
                                    }
                                }
                            }

                            echo "<td>" . (!empty($akses_aktif) ? implode(', ', $akses_aktif) : '-') . "</td>";

                            // Created at
                            echo "<td>" . htmlspecialchars($row['created_at']) . "</td>";

                            // Tombol Edit & Delete
                            echo "<td>
                    <button class='btn-sm btn btn-warning btn-edit'
                        data-id='" . $row['id'] . "'
                        data-username='" . $row['username'] . "'
                        data-nama='" . $row['nama'] . "'
                        data-email='" . $row['email'] . "'
                        data-access='" . htmlspecialchars($row['access_modul'], ENT_QUOTES) . "'
                        data-tipe='" . $row['tipe'] . "'
                        data-jabatan='" . $row['jabatan'] . "'
                        data-gender='" . $row['gender'] . "'
                        data-sub_unit_id='" . $row['sub_unit_id'] . "'
                        >
                        <i class='fas fa-edit'></i>
                    </button>

                    <button class='btn-sm btn btn-danger btn-delete'
                        data-id='" . $row['id'] . "'>
                        <i class='fas fa-trash-alt'></i>
                    </button>
                </td>";

                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='10' class='text-center'>Tidak ada data</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
            <?php if ($totalPages > 1): ?>
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center mt-3">
                        <!-- Prev -->
                        <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?limit=<?= $selectedLimit ?>&page=<?= max(1, $page - 1) ?>&search=<?= urlencode($search) ?>">Prev</a>
                        </li>

                        <!-- Halaman -->
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= $page == $i ? 'active' : '' ?>">
                                <a class="page-link" href="?limit=<?= $selectedLimit ?>&page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>

                        <!-- Next -->
                        <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?limit=<?= $selectedLimit ?>&page=<?= min($totalPages, $page + 1) ?>&search=<?= urlencode($search) ?>">Next</a>
                        </li>
                    </ul>
                </nav>
            <?php endif; ?>


            <!-- Modal for Delete Confirmation -->
            <div id="deleteUserModal" class="modal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Konfirmasi Hapus</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form method="POST" action="dashboard.php">
                                <input type="hidden" name="delete_user_id" id="deleteUserId">
                                <p class="text-center">Yakin ingin menghapus user ini?</p>
                                <div class="d-flex justify-content-center gap-2 mt-4">
                                    <a href="dashboard.php" class="btn btn-secondary">Batal</a>
                                    <button type="submit" name="confirm_delete" class="btn btn-danger">Hapus</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>




            <!-- Modal for Edit User -->
            <div id="editUserModal" class="modal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Edit User</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form method="POST" action="dashboard.php">
                                <input type="hidden" name="id" id="editUserId">
                                <div class="mb-3">
                                    <label for="editNama" class="form-label">Nama</label>
                                    <input type="text" name="nama" id="editNama" class="form-control">
                                </div>
                                <div class="mb-3">
                                    <label for="editUsername" class="form-label">Username</label>
                                    <input type="text" name="username" id="editUsername" class="form-control">
                                </div>

                                <div class="mb-3">
                                    <label for="editPassword" class="form-label">Password</label>
                                    <input type="password" name="password" id="editPassword" class="form-control" placeholder="Kosongkan jika tidak diubah">
                                </div>
                                <div class="mb-3">
                                    <label for="editEmail" class="form-label">Email</label>
                                    <input type="email" name="email" id="editEmail" class="form-control">
                                </div>
                                <div class="mb-3">
                                    <label for="editTipe" class="form-label">Tipe</label>
                                    <select name="tipe" id="editTipe" class="form-control">
                                        <option value="admin">Admin</option>
                                        <option value="user">User</option>
                                        <option value="editor">Editor</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="editJabatan" class="form-label">Jabatan</label>
                                    <input type="text" name="jabatan" id="editJabatan" class="form-control">
                                </div>
                                <div class="mb-3">
                                    <label for="editSubUnit" class="form-label">Sub Unit Kerja (Opsional)</label>
                                    <select name="sub_unit_id" id="editSubUnit" class="form-control">
                                        <option value="">-- Tidak Memilih Sub Unit --</option>
                                        <?php while ($sub = $subUnitList->fetch_assoc()): ?>
                                            <option value="<?= $sub['id'] ?>"><?= htmlspecialchars($sub['sub_unit_name']) ?></option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>


                                <div class="mb-3">
                                    <label for="editGender" class="form-label">Gender</label>
                                    <select name="gender" id="editGender" class="form-control">
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                    </select>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="akses_berita" id="aksesBerita">
                                    <label class="form-check-label" for="aksesBerita">Berita</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="akses_sosial" id="aksesSosial">
                                    <label class="form-check-label" for="aksesSosial">Tanggung jawab</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="akses_gaji" id="aksesGaji">
                                    <label class="form-check-label" for="aksesGaji">Gaji</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="akses_surat" id="aksesSurat">
                                    <label class="form-check-label" for="aksesSurat">Surat</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="akses_agenda" id="aksesAgenda">
                                    <label class="form-check-label" for="aksesAgenda">Agenda</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="akses_todolist" id="aksesTodolist">
                                    <label class="form-check-label" for="aksesTodolist">To do list</label>
                                </div>


                                <div class="text-end">
                                    <a href="dashboard.php" class="btn btn-secondary">Batal</a>
                                    <button type="submit" name="edit_user" class="btn btn-primary">Update</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal for Create User -->
            <div id="createUserModal" class="modal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Tambah User</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form method="POST" action="dashboard.php">
                                <div class="mb-3">
                                    <label for="createNama" class="form-label">Nama</label>
                                    <input type="text" name="nama" id="createNama" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label for="createUsername" class="form-label">Username</label>
                                    <input type="text" name="username" id="createUsername" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label for="createPassword" class="form-label">Password</label>
                                    <input type="password" name="password" id="createPassword" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label for="createEmail" class="form-label">Email</label>
                                    <input type="email" name="email" id="createEmail" class="form-control">
                                </div>

                                <div class="mb-3">
                                    <label for="createTipe" class="form-label">Tipe</label>
                                    <select name="tipe" id="createTipe" class="form-control">
                                        <option value="admin">Admin</option>
                                        <option value="user">User</option>
                                        <option value="editor">Editor</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="createJabatan" class="form-label">Jabatan</label>
                                    <input type="text" name="jabatan" id="createJabatan" class="form-control">
                                </div>
                                <div class="mb-3">
                                    <label for="createSubUnit" class="form-label">Sub Unit Kerja (Opsional)</label>
                                    <select name="sub_unit_id" id="createSubUnit" class="form-control">
                                        <option value="" selected>-- Tidak Memilih Sub Unit --</option>
                                        <?php while ($sub = $subUnitListCreate->fetch_assoc()): ?>
                                            <option value="<?= $sub['id'] ?>"><?= htmlspecialchars($sub['sub_unit_name']) ?></option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>




                                <div class="mb-3">
                                    <label for="createGender" class="form-label">Gender</label>
                                    <select name="gender" id="createGender" class="form-control">
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Akses Modul</label><br>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" name="akses_berita" id="createAksesBerita">
                                        <label class="form-check-label" for="createAksesBerita">Berita</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" name="akses_sosial" id="createAksesSosial">
                                        <label class="form-check-label" for="createAksesSosial">Tanggung jawab</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" name="akses_gaji" id="createAksesGaji">
                                        <label class="form-check-label" for="createAksesGaji">Gaji</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" name="akses_surat" id="createAksesSurat">
                                        <label class="form-check-label" for="createAksesSurat">Surat</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" name="akses_agenda" id="createAksesAgenda">
                                        <label class="form-check-label" for="createAksesAgenda">Agenda</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" name="akses_todolist" id="createAksesTodolist">
                                        <label class="form-check-label" for="createAksesTodolist">To do list</label>
                                    </div>

                                </div>


                                <div class="text-end">
                                    <button type="submit" name="create_user" class="btn btn-success">Simpan</button>
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

            <script>
                const searchInputNew = document.getElementById('searchInputNew');
                const searchButtonNew = document.getElementById('searchButtonNew');

                // Event listener untuk memperlihatkan tombol ketika input diklik
                searchInputNew.addEventListener('focus', function() {
                    searchButtonNew.classList.add('show'); // Tampilkan tombol
                    searchInputNew.placeholder = ''; // Hilangkan placeholder
                });

                // Event listener untuk menyembunyikan tombol ketika input kosong
                searchInputNew.addEventListener('blur', function() {
                    if (!searchInputNew.value.trim()) {
                        searchButtonNew.classList.remove('show'); // Sembunyikan tombol
                        searchInputNew.placeholder = 'Tap untuk mencari...'; // Kembalikan placeholder
                    }
                });


                document.querySelectorAll('.btn-delete').forEach(button => {
                    button.addEventListener('click', function() {
                        document.getElementById('deleteUserId').value = this.dataset.id;
                        new bootstrap.Modal(document.getElementById('deleteUserModal')).show();
                    });
                });


                document.querySelectorAll('.btn-edit').forEach(button => {
                    button.addEventListener('click', function() {
                        document.getElementById('editUserId').value = this.dataset.id;
                        document.getElementById('editUsername').value = this.dataset.username;
                        document.getElementById('editNama').value = this.dataset.nama;
                        document.getElementById('editEmail').value = this.dataset.email;
                        document.getElementById('editTipe').value = this.dataset.tipe;
                        document.getElementById('editJabatan').value = this.dataset.jabatan;
                        document.getElementById('editGender').value = this.dataset.gender;
                        document.getElementById('editSubUnit').value = this.dataset.sub_unit_id;

                        // Reset dan centang akses
                        document.getElementById('aksesBerita').checked = false;
                        document.getElementById('aksesSosial').checked = false;
                        document.getElementById('aksesGaji').checked = false;
                        document.getElementById('aksesSurat').checked = false;
                        document.getElementById('aksesAgenda').checked = false;

                        try {
                            const akses = JSON.parse(this.dataset.access);
                            if (akses.berita === 'on') document.getElementById('aksesBerita').checked = true;
                            if (akses.sosial === 'on') document.getElementById('aksesSosial').checked = true;
                            if (akses.gaji === 'on') document.getElementById('aksesGaji').checked = true;
                            if (akses.surat === 'on') document.getElementById('aksesSurat').checked = true;
                            if (akses.agenda === 'on') document.getElementById('aksesAgenda').checked = true;
                            if (akses.todolist === 'on') document.getElementById('aksesTodolist').checked = true;
                        } catch (e) {
                            console.error("Gagal parse access_modul");
                        }

                        new bootstrap.Modal(document.getElementById('editUserModal')).show();
                    });
                });



                document.addEventListener('DOMContentLoaded', function() {
                    var editButtons = document.querySelectorAll('.btn-edit');
                    var modal = new bootstrap.Modal(document.getElementById('editUserModal'));

                    editButtons.forEach(function(button) {
                        button.addEventListener('click', function() {
                            var userId = this.getAttribute('data-id');
                            var username = this.getAttribute('data-username');
                            document.getElementById('editUserId').value = userId;
                            document.getElementById('editUsername').value = username;
                            modal.show();
                        });
                    });
                });
            </script>
            <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>