<?php
session_start();
include(__DIR__ . '/../includes/koneksi.php');
include(__DIR__ . '/../includes/functions.php');

// Helper to ensure 'Unassigned' unit exists and return its id
function getOrCreateUnassignedUnitId($conn)
{
    $unitName = 'Unassigned';
    $stmt = $conn->prepare('SELECT id FROM unit WHERE unit_name = ? LIMIT 1');
    $stmt->bind_param('s', $unitName);
    $stmt->execute();
    $r = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    if ($r && isset($r['id'])) return (int)$r['id'];
    // Insert new row
    $ins = $conn->prepare('INSERT INTO unit (unit_name) VALUES (?)');
    $ins->bind_param('s', $unitName);
    if ($ins->execute()) {
        $newId = $ins->insert_id;
        $ins->close();
        return (int)$newId;
    }
    $ins->close();
    return null;
}

// Admin check
if (!isAdmin($conn)) {
    header('Location: login.php');
    exit();
}

// count active agendas for sidebar badge
date_default_timezone_set("Asia/Jakarta");
$today = date('Y-m-d');
$nowTime = date('H:i');
$countQuery = "SELECT COUNT(*) as jumlah FROM agenda WHERE tanggal > ? OR (tanggal = ? AND waktu >= ?)";
$countStmt = $conn->prepare($countQuery);
$countStmt->bind_param("sss", $today, $today, $nowTime);
$countStmt->execute();
$countResult = $countStmt->get_result()->fetch_assoc();
$jumlahAgendaAktif = $countResult['jumlah'] ?? 0;

$errors = [];
$success = null;

// Show message based on GET params after redirect
if (!empty($_GET['added'])) $success = 'Penyetuju berhasil ditambahkan.';
if (!empty($_GET['deleted'])) $success = 'Penyetuju berhasil dihapus.';

$selectedUserId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : null;
$selectedUserName = null;
$selectedUserJabatan = null;
$selectedUserType = null;
$selectedUserSubUnitId = null;
if ($selectedUserId) {
    $q = $conn->prepare('SELECT nama, tipe, jabatan, sub_unit_id FROM users WHERE id = ? LIMIT 1');
    $q->bind_param('i', $selectedUserId);
    $q->execute();
    $res = $q->get_result();
    $rown = $res ? $res->fetch_assoc() : null;
    $selectedUserName = $rown['nama'] ?? null;
    $selectedUserType = isset($rown['tipe']) ? strtolower(trim($rown['tipe'])) : null;
    $selectedUserJabatan = $rown['jabatan'] ?? null;
    $selectedUserSubUnitId = isset($rown['sub_unit_id']) ? (int)$rown['sub_unit_id'] : null;
    $q->close();
    // If provided user_id is not tipe 'user', reject it and clear selection
    if ($selectedUserType !== 'user') {
        $errors[] = 'Pengguna tidak valid: hanya pengguna bertipe "user" yang dapat dipilih.';
        $selectedUserId = null;
        $selectedUserName = null;
    }
}

// Pre-configured list (names) to show in the Nama User select
// Build supervisor map for cycle detection
list($map, $nameMap) = buildSupervisorMap($conn);

$sql = "SELECT u.id, u.nama, u.jabatan FROM users u LEFT JOIN letter_order lo ON lo.user_id = u.id WHERE lo.user_id IS NULL AND LOWER(u.tipe) = 'user' ORDER BY u.nama";
$res = $conn->query($sql);
$availableUsers = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];

// Fetch supervisors: all users
$supervisors = [];
if ($r = $conn->query('SELECT id, nama, jabatan FROM users ORDER BY nama')) {
    $supervisors = $r->fetch_all(MYSQLI_ASSOC);
    $r->free();
}

// Note: no admin unit override in this flow

// The Add page allows creation of a mapping and also crafting a chain (penyetuju) for the selected user.
// Handle manage chain actions (Tambah/Hapus Penyetuju) on this page when user_id is selected
// New unified chain save action: allow storing multiple approvers at once
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['chain_action']) && $_POST['chain_action'] === 'save_chain') {
    $chainUserId = isset($_POST['chain_user_id']) ? (int)$_POST['chain_user_id'] : 0;
    $approverIds = isset($_POST['approver_id']) && is_array($_POST['approver_id']) ? $_POST['approver_id'] : [];
    $urutans = isset($_POST['urutan']) && is_array($_POST['urutan']) ? $_POST['urutan'] : [];
    if ($chainUserId <= 0) $errors[] = 'Pengguna target tidak valid.';
    else {
        $q = $conn->prepare('SELECT tipe FROM users WHERE id = ? LIMIT 1');
        $q->bind_param('i', $chainUserId);
        $q->execute();
        $rowt = $q->get_result()->fetch_assoc();
        $q->close();
        $ctype = isset($rowt['tipe']) ? strtolower(trim($rowt['tipe'])) : null;
        if ($ctype !== 'user') $errors[] = 'Pengguna target tidak valid: hanya pengguna bertipe "user" yang dapat memiliki penyetuju.';
    }
    if (empty($errors)) {
        // Validate array length and prepare inserts
        $pairs = [];
        for ($i = 0; $i < count($approverIds); $i++) {
            $aid = (int)$approverIds[$i];
            $ur = isset($urutans[$i]) ? (int)$urutans[$i] : ($i + 1);
            if ($aid <= 0) continue; // skip invalid
            if ($aid === $chainUserId) {
                $errors[] = 'Penyetuju tidak boleh sama dengan pengguna.';
                break;
            }
            $pairs[] = ['approver_id' => $aid, 'urutan' => $ur];
        }
        if (empty($errors)) {
            // Remove existing chain rows (we will reinsert)
            $del = $conn->prepare('DELETE FROM approval_chain WHERE user_id = ?');
            $del->bind_param('i', $chainUserId);
            if (!$del->execute()) {
                $errors[] = 'Gagal membersihkan penyetuju lama: ' . $del->error;
            }
            $del->close();
        }
        if (empty($errors)) {
            // Insert new chain rows
            $unassignedUsed = false;
            foreach ($pairs as $p) {
                // Determine unit id: user sub_unit_id or approver's sub_unit_id or Unassigned
                $unit_id = null;
                $stmt = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
                $stmt->bind_param('i', $chainUserId);
                $stmt->execute();
                $ure = $stmt->get_result()->fetch_assoc();
                $stmt->close();
                $unit_id = isset($ure['sub_unit_id']) ? (int)$ure['sub_unit_id'] : null;
                if ($unit_id === null) {
                    // try approver's unit
                    $stmt2 = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
                    $stmt2->bind_param('i', $p['approver_id']);
                    $stmt2->execute();
                    $arr = $stmt2->get_result()->fetch_assoc();
                    $stmt2->close();
                    $appr_unit = isset($arr['sub_unit_id']) ? (int)$arr['sub_unit_id'] : null;
                    if ($appr_unit !== null) $unit_id = $appr_unit;
                }
                if ($unit_id === null) {
                    $unit_id = getOrCreateUnassignedUnitId($conn);
                    $unassignedUsed = true;
                }
                // final validation
                if ($unit_id === null) {
                    $errors[] = 'Tidak dapat menemukan unit untuk penyetuju.';
                    break;
                }
                $ins = $conn->prepare('INSERT INTO approval_chain (unit_id, user_id, approver_id, urutan) VALUES (?, ?, ?, ?)');
                $ins->bind_param('iiii', $unit_id, $chainUserId, $p['approver_id'], $p['urutan']);
                if (!$ins->execute()) {
                    $errors[] = 'Gagal menambahkan penyetuju: ' . $ins->error;
                    $ins->close();
                    break;
                }
                $ins->close();
            }
        }
        if (empty($errors)) {
            $success = 'Daftar penyetuju berhasil disimpan.';
            if (!empty($unassignedUsed)) {
                $success .= ' Perhatian: beberapa penyetuju telah disimpan dengan unit "Unassigned" karena tidak ada unit yang terkait.';
            }
            header('Location: add-letter-order.php?user_id=' . (int)$chainUserId . '&saved=1');
            exit();
        }
    }
} else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['chain_action'])) {
    $chainAction = $_POST['chain_action'];
    $chainUserId = isset($_POST['chain_user_id']) ? (int)$_POST['chain_user_id'] : $selectedUserId;
    if ($chainAction === 'add') {
        $approver_id = isset($_POST['approver_id']) && $_POST['approver_id'] !== '' ? (int)$_POST['approver_id'] : 0;
        $urutan = isset($_POST['urutan']) ? (int)$_POST['urutan'] : 1;
        // Validate that the target chain user is a 'user' type
        if ($chainUserId <= 0) $errors[] = 'Pengguna target tidak valid.';
        else {
            $q = $conn->prepare('SELECT tipe FROM users WHERE id = ? LIMIT 1');
            $q->bind_param('i', $chainUserId);
            $q->execute();
            $rst = $q->get_result()->fetch_assoc();
            $q->close();
            $ctype = isset($rst['tipe']) ? strtolower(trim($rst['tipe'])) : null;
            if ($ctype !== 'user') $errors[] = 'Pengguna target tidak valid: hanya pengguna bertipe "user" yang dapat memiliki penyetuju.';
        }
        if ($approver_id <= 0) $errors[] = 'Penyetuju harus dipilih.';
        if ($approver_id === $chainUserId) $errors[] = 'Penyetuju tidak boleh sama dengan pengguna.';
        if (empty($errors)) {
            // determine unit by user's sub_unit (no admin override)
            $stmt = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
            $stmt->bind_param('i', $chainUserId);
            $stmt->execute();
            $uRow = $stmt->get_result()->fetch_assoc();
            $stmt->close();
            $unit_id = isset($uRow['sub_unit_id']) ? (int)$uRow['sub_unit_id'] : null;
            // If user's sub_unit_id is not set or invalid, try approver's sub_unit_id as a fallback
            if ($unit_id === null) {
                $stmt2 = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
                $stmt2->bind_param('i', $approver_id);
                $stmt2->execute();
                $apprRow = $stmt2->get_result()->fetch_assoc();
                $stmt2->close();
                $appr_unit_id = isset($apprRow['sub_unit_id']) ? (int)$apprRow['sub_unit_id'] : null;
                if ($appr_unit_id !== null) $unit_id = $appr_unit_id;
            }
            // validate the unit exists: if not, reject operation
            if ($unit_id !== null) {
                $ch = $conn->prepare('SELECT id FROM unit WHERE id = ? LIMIT 1');
                $ch->bind_param('i', $unit_id);
                $ch->execute();
                $unitRow = $ch->get_result()->fetch_assoc();
                $ch->close();
                if (!$unitRow) {
                    $errors[] = 'Gagal menambahkan penyetuju: Unit pengguna tidak ditemukan. Silakan set sub_unit_id pada profil pengguna terlebih dahulu.';
                }
            } else {
                // if user has no unit, fallback to approver's unit; if still none, use Unassigned
                $stmtApp = $conn->prepare('SELECT sub_unit_id FROM users WHERE id = ? LIMIT 1');
                $stmtApp->bind_param('i', $approver_id);
                $stmtApp->execute();
                $appRow = $stmtApp->get_result()->fetch_assoc();
                $stmtApp->close();
                $app_unit_id = isset($appRow['sub_unit_id']) ? (int)$appRow['sub_unit_id'] : null;
                if ($app_unit_id !== null) {
                    $unit_id = $app_unit_id;
                    // revalidate
                    $ch2 = $conn->prepare('SELECT id FROM unit WHERE id = ? LIMIT 1');
                    $ch2->bind_param('i', $unit_id);
                    $ch2->execute();
                    $unitRow2 = $ch2->get_result()->fetch_assoc();
                    $ch2->close();
                    if (!$unitRow2) {
                        $unit_id = null;
                    }
                }
                if ($unit_id === null) {
                    $unit_id = getOrCreateUnassignedUnitId($conn);
                }
            }
            if (empty($errors)) {
                $ins = $conn->prepare('INSERT INTO approval_chain (unit_id, user_id, approver_id, urutan) VALUES (?, ?, ?, ?)');
                $ins->bind_param('iiii', $unit_id, $chainUserId, $approver_id, $urutan);
                if ($ins->execute()) {
                    $success = 'Penyetuju berhasil ditambahkan.';
                    header('Location: add-letter-order.php?user_id=' . $chainUserId . '&added=1');
                    exit();
                } else {
                    $errors[] = 'Gagal menambahkan penyetuju: ' . $ins->error;
                }
                $ins->close();
            }
        }
    } elseif ($chainAction === 'delete') {
        $id = isset($_POST['chain_id']) ? (int)$_POST['chain_id'] : 0;
        if ($id > 0) {
            // Validate that the target chain user is a 'user' type
            if ($chainUserId <= 0) $errors[] = 'Pengguna target tidak valid.';
            else {
                $q2 = $conn->prepare('SELECT tipe FROM users WHERE id = ? LIMIT 1');
                $q2->bind_param('i', $chainUserId);
                $q2->execute();
                $rst2 = $q2->get_result()->fetch_assoc();
                $q2->close();
                $ctype2 = isset($rst2['tipe']) ? strtolower(trim($rst2['tipe'])) : null;
                if ($ctype2 !== 'user') $errors[] = 'Pengguna target tidak valid: hanya pengguna bertipe "user" yang dapat memiliki penyetuju.';
            }
            $del = $conn->prepare('DELETE FROM approval_chain WHERE id = ? LIMIT 1');
            $del->bind_param('i', $id);
            if ($del->execute()) {
                $success = 'Penyetuju berhasil dihapus.';
                header('Location: add-letter-order.php?user_id=' . $chainUserId . '&deleted=1');
                exit();
            } else {
                $errors[] = 'Gagal menghapus penyetuju: ' . $del->error;
            }
        }
    }
}

// Normal create mapping flow
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['chain_action'])) {
    $userId = isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0;
    $supervisorId = isset($_POST['supervisor_id']) && $_POST['supervisor_id'] !== '' ? (int)$_POST['supervisor_id'] : null;

    if ($userId <= 0) $errors[] = 'Pengguna harus dipilih.';
    else {
        // validate user type
        $q = $conn->prepare('SELECT tipe FROM users WHERE id = ? LIMIT 1');
        $q->bind_param('i', $userId);
        $q->execute();
        $userTypeRow = $q->get_result()->fetch_assoc();
        $q->close();
        $userType = isset($userTypeRow['tipe']) ? strtolower(trim($userTypeRow['tipe'])) : null;
        if ($userType !== 'user') $errors[] = 'Pengguna tidak valid: hanya pengguna bertipe "user" yang dapat dipilih.';
    }
    // Can't set user as their own supervisor
    if ($supervisorId !== null && $userId === $supervisorId) $errors[] = 'User cannot be their own supervisor.';

    // Ensure user is still available
    $existsCheck = $conn->prepare('SELECT id FROM letter_order WHERE user_id = ? LIMIT 1');
    $existsCheck->bind_param('i', $userId);
    $existsCheck->execute();
    $exists = $existsCheck->get_result()->fetch_assoc();
    $existsCheck->close();
    if ($exists) $errors[] = 'Letter order for that user already exists.';

    // Reload map then check cycle
    list($map, $nameMap) = buildSupervisorMap($conn);
    if (createsCycle($userId, $supervisorId, $map)) {
        $errors[] = 'Setting this supervisor would create a cycle in the chain.';
    }

    if (empty($errors)) {
        // get admin id from username
        $adminId = null;
        if (isset($_SESSION['username'])) {
            $q = $conn->prepare('SELECT id FROM users WHERE username = ? LIMIT 1');
            $q->bind_param('s', $_SESSION['username']);
            $q->execute();
            $res = $q->get_result();
            $row = $res ? $res->fetch_assoc() : null;
            $q->close();
            $adminId = $row['id'] ?? null;
        }

        // Use dynamic SQL to allow NULL supervisor
        if ($supervisorId === null) {
            $ins = $conn->prepare('INSERT INTO letter_order (user_id, supervisor_id, created_by) VALUES (?, NULL, ?)');
            $ins->bind_param('ii', $userId, $adminId);
            $debugSql = "INSERT INTO letter_order (user_id, supervisor_id, created_by) VALUES ($userId, NULL, $adminId)";
        } else {
            $ins = $conn->prepare('INSERT INTO letter_order (user_id, supervisor_id, created_by) VALUES (?, ?, ?)');
            $ins->bind_param('iii', $userId, $supervisorId, $adminId);
            $debugSql = "INSERT INTO letter_order (user_id, supervisor_id, created_by) VALUES ($userId, $supervisorId, $adminId)";
        }
        // Debug
        dev_log("ADD LETTER ORDER: userId=$userId supervisorId=" . ($supervisorId ?? 'NULL') . " adminId=" . ($adminId ?? 'NULL') . " SQL={$debugSql}");
        if ($ins->execute()) {
            $newId = $ins->insert_id;
            dev_log("Added letter_order id={$newId} for user={$userId}");
            $success = 'Pemetaan urutan surat berhasil dibuat.';
            // Redirect to edit page for this mapping so admin can manage approver chain inline
            header('Location: edit-letter-order.php?id=' . $newId . '&created=1');
            exit();
        } else {
            $errors[] = 'Failed to create mapping: ' . $ins->error;
            dev_log('ADD LETTER ORDER FAIL: ' . $ins->error . ' SQL: ' . $debugSql);
        }
        $ins->close();
    }
}

// Load current approvers for selected user if user_id is specified
$chainRows = [];
$selUser = $selectedUserId;
if ($selUser && $selUser > 0) {
    $stmt = $conn->prepare('SELECT ac.id, ac.unit_id, ac.user_id, ac.approver_id, ac.urutan, u.nama as approver_name, un.unit_name as unit_name FROM approval_chain ac LEFT JOIN users u on ac.approver_id = u.id LEFT JOIN unit un on ac.unit_id = un.id WHERE ac.user_id = ? ORDER BY ac.urutan');
    $stmt->bind_param('i', $selUser);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res) $chainRows = $res->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Tambah Urutan Surat</title>
    <link href="img/baru/logojp.png" rel="icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<style>
    /* reuse sidebar style */
    .sidebar {
        background-color: #0c50e1;
        color: white;
        min-height: 100vh;
        padding: 15px;
    }

    .sidebar a {
        color: white;
        display: block;
        padding: 10px;
        margin: 5px 0;
    }

    .sidebar a:hover,
    .sidebar a.active {
        background-color: #ffc107;
        color: #0047ab;
    }
</style>

<body>
    <div class="d-flex">
        <div class="sidebar">
            <a href="#"><img src="/jasa_marga/img/logojpt-new/Logo Header New.png" alt="#" style="width: 200px"></a>
            <a href="dashboard.php"><i class="fas fa-bars"></i> Dashboard</a>
            <a href="gaji.php"><i class="fas fa-money-bill-wave"></i> Gaji Pegawai</a>
            <a href="surat.php"><i class="fas fa-file-alt"></i> Surat Lainnya</a>

            <a href="#letterSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#letterSubmenu">
                <i class="fas fa-envelope-open-text"></i> Surat
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="letterSubmenu" class="collapse submenu">
                <a href="create-letter.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'create-letter.php') ? 'active' : ''; ?>"><i class="fas fa-pen-to-square"></i> Buat Surat</a>
                <a href="record-letter.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'record-letter.php') ? 'active' : ''; ?>"><i class="fas fa-folder-open"></i> Record Surat</a>
                <a href="manajemen-surat.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'manajemen-surat.php') ? 'active' : ''; ?>"><i class="fas fa-folder-open"></i> Manajemen Data Surat</a>
                <a href="letter-order.php" class="<?= (basename($_SERVER['PHP_SELF']) === 'letter-order.php') ? 'active' : ''; ?>"><i class="fas fa-list-ol"></i> Urutan Surat</a>
            </div>

            <a href="#todolistSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#todolistSubmenu">
                <i class="fas fa-tasks"></i> To Do List Pekerjaan
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="todolistSubmenu" class="collapse submenu">
                <a href="todolist.php"><i class="fas fa-database"></i> Manajemen Data</a>
                <a href="record-todolist.php"><i class="fas fa-history"></i> Record To Do List</a>
            </div>

            <a href="#agendaSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#agendaSubmenu">
                <i class="fas fa-calendar-check"></i> Agenda Kerja
                <?php if ($jumlahAgendaAktif > 0): ?>
                    <span class="badge bg-danger ms-2"><?= $jumlahAgendaAktif ?></span>
                <?php endif; ?>
                <i class="fas fa-caret-down arrow-icon ml-1" id="agendaArrow"></i>
            </a>

            <div id="agendaSubmenu" class="collapse submenu">
                <a href="list-agenda.php">
                    <i class="fas fa-clock"></i> List
                    <?php if ($jumlahAgendaAktif > 0): ?>
                        <span class="badge bg-danger ms-1"><?= $jumlahAgendaAktif ?></span>
                    <?php endif; ?>
                </a>
                <a href="record-agenda.php">
                    <i class="fas fa-clipboard-list"></i> Record
                </a>
            </div>
            <a href="sub-unit-kerja.php"><i class="fas fa-sitemap"></i> Manajemen Unit Kerja</a>
            <a href="#systemSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#systemSubmenu">
                <i class="fas fa-newspaper"></i> Interface
                <i class="fas fa-caret-down arrow-icon ml-1" id="systemArrow"></i>
            </a>
            <div id="systemSubmenu" class="collapse submenu">
                <a href="kontak.php"><i class="fas fa-paper-plane"></i> Contact</a>
                <a href="footer.php"><i class="fas fa-shoe-prints"></i> Footer</a>
                <a href="header.php"><i class="fas fa-heading"></i> Header</a>
                <a href="home.php"><i class="fas fa-house-user"></i> Home</a>
                <a href="nav.php"><i class="fas fa-landmark"></i> Navbar</a>
                <a href="prof.php"><i class="fas fa-user-circle"></i> Profil</a>
                <a href="trav.php"><i class="fas fa-font"></i> Travoy</a>
                <a href="jaringan.php"><i class="fas fa-car"></i> Jaringan Tol</a>
                <a href="chatbot1.php"><i class="fas fa-comments"></i> Chatbot</a>
                <a href="gratifi.php"><i class="fas fa-gift"></i> Gratifikasi</a>
            </div>
            <a href="#locSubmenu" class="submenu-toggle" data-bs-toggle="collapse" data-bs-target="#locSubmenu">
                <i class="fas fa-images" class="active"></i> Tampilan Gambar
                <i class="fas fa-caret-down arrow-icon ml-1" id="locArrow"></i>
            </a>
            <div id="locSubmenu" class="collapse submenu">
                <a href="berita.php"><i class="fas fa-newspaper"></i> Berita </a>
                <a href="sosial.php"><i class="fas fa-file"></i> Tanggung jawab </a>
                <a href="direk.php"><i class="fas fa-user-tie"></i> Direksi </a>
                <a href="komis.php"><i class="fas fa-users"></i> Komisaris </a>
                <a href="organisasi.php"><i class="fas fa-layer-group"></i> Organisasi </a>
                <a href="gerbang.php"><i class="fas fa-road"></i> Gerbang Tol </a>
            </div>
            <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
        <div id="mainContent" class="container-fluid py-3">
            <h3>Tambah Urutan Surat</h3>
            <a href="letter-order.php" class="btn btn-secondary mb-3">Kembali</a>

            <?php if ($success): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <?php endif; ?>
            <?php if (!empty($errors)): ?>
                <div class="alert alert-danger">
                    <ul><?php foreach ($errors as $e) echo '<li>' . htmlspecialchars($e) . '</li>'; ?></ul>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">Nama Pengguna (tipe user, belum memiliki pemetaan)</label>
                    <select class="form-select" name="user_id" required>
                        <option value="">-- Pilih Pengguna --</option>
                        <?php foreach ($availableUsers as $u): ?>
                            <?php $jab = !empty($u['jabatan']) ? ' - ' . htmlspecialchars($u['jabatan']) : ''; ?>
                            <option value="<?= (int)$u['id'] ?>" <?= (!empty($selectedUserId) && (int)$selectedUserId === (int)$u['id']) ? 'selected' : '' ?>><?= htmlspecialchars($u['nama']) ?><?= $jab ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Nama Atasan</label>
                    <select class="form-select" name="supervisor_id">
                        <option value="">-- Tanpa Atasan --</option>
                        <?php foreach ($supervisors as $s): ?>
                            <option value="<?= (int)$s['id'] ?>"><?= htmlspecialchars($s['nama']) ?> <?= $s['jabatan'] ? ' - ' . htmlspecialchars($s['jabatan']) : '' ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Buat Pemetaan</button>
            </form>

            <?php if ($selectedUserId): ?>
                <hr>

                <h4>Daftar Atasan untuk <?= htmlspecialchars($selectedUserName ?? '(selected)') ?><?= $selectedUserJabatan ? ' - ' . htmlspecialchars($selectedUserJabatan) : '' ?></h4>
                <?php
                // Prebuild options for JS template
                $supervisorOptionsHtml = '';
                foreach ($supervisors as $s) {
                    if ((int)$s['id'] === (int)$selectedUserId) continue;
                    $supervisorOptionsHtml .= '<option value="' . (int)$s['id'] . '">' . htmlspecialchars($s['nama']);
                    if (!empty($s['jabatan'])) $supervisorOptionsHtml .= ' - ' . htmlspecialchars($s['jabatan']);
                    $supervisorOptionsHtml .= '</option>';
                }
                ?>
                <form method="POST" id="chainForm">
                    <input type="hidden" name="chain_action" value="save_chain">
                    <input type="hidden" name="chain_user_id" value="<?= (int)$selectedUserId ?>">
                    <div id="approversContainer">
                        <?php $i = 1;
                        foreach ($chainRows as $row): ?>
                            <div class="mb-3 approver-row">
                                <label class="form-label">Atasan <?= $i ?></label>
                                <select name="approver_id[]" class="form-select mb-1">
                                    <option value="">-- Pilih Penyetuju --</option>
                                    <?php foreach ($supervisors as $s): if ((int)$s['id'] === (int)$selectedUserId) continue; ?>
                                        <option value="<?= (int)$s['id'] ?>" <?= ((int)$row['approver_id'] === (int)$s['id']) ? 'selected' : '' ?>><?= htmlspecialchars($s['nama']) ?><?= $s['jabatan'] ? ' - ' . htmlspecialchars($s['jabatan']) : '' ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <input type="hidden" name="urutan[]" value="<?= (int)$row['urutan'] ?>" />
                                <button type="button" class="btn btn-sm btn-danger mt-1 remove-approver">Hapus</button>
                            </div>
                        <?php $i++;
                        endforeach; ?>
                    </div>
                    <div class="mb-3">
                        <button id="addApproverBtn" type="button" class="btn btn-secondary">Tambah Atasan</button>
                        <button type="submit" class="btn btn-primary">Simpan Atasan</button>
                    </div>
                </form>
                <!-- Old single-add form removed; use the Atasan list above to add/update approvers -->
                <script>
                    const supervisorOptions = <?= json_encode($supervisorOptionsHtml) ?>;
                    document.addEventListener('DOMContentLoaded', function() {
                        const container = document.getElementById('approversContainer');
                        const addBtn = document.getElementById('addApproverBtn');
                        addBtn.addEventListener('click', function() {
                            const index = container.querySelectorAll('.approver-row').length + 1;
                            const row = document.createElement('div');
                            row.className = 'mb-3 approver-row';
                            row.innerHTML = `\n                            <label class="form-label">Atasan ${index}</label>\n                            <select name="approver_id[]" class="form-select mb-1">${supervisorOptions}</select>\n                            <input type="hidden" name="urutan[]" value="${index}">\n                            <button type="button" class="btn btn-sm btn-danger mt-1 remove-approver">Hapus</button>\n                        `;
                            container.appendChild(row);
                        });
                        container.addEventListener('click', function(e) {
                            if (e.target && e.target.matches('.remove-approver')) {
                                const row = e.target.closest('.approver-row');
                                row.remove();
                                // re-label the remaining rows
                                const rows = container.querySelectorAll('.approver-row');
                                rows.forEach((r, i) => {
                                    const label = r.querySelector('.form-label');
                                    const input = r.querySelector('input[type=hidden]');
                                    label.textContent = `Atasan ${i+1}`;
                                    if (input) input.value = i + 1;
                                });
                            }
                        });
                    });
                </script>
            <?php endif; ?>
        </div>
    </div>
</body>

</html>